/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.examination.solver.selector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.decider.selector.AbstractSelector;
import org.drools.planner.core.move.Move;
import org.drools.planner.examples.examination.domain.Exam;
import org.drools.planner.examples.examination.domain.Examination;
import org.drools.planner.examples.examination.solver.move.factory.ExamSwapMoveFactory;
import org.drools.planner.examples.examination.solver.move.factory.PeriodChangeMoveFactory;
import org.drools.planner.examples.examination.solver.move.factory.RoomChangeMoveFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllMovesOfOneExamSelector
extends AbstractSelector {
    protected PeriodChangeMoveFactory periodChangeMoveFactory = new PeriodChangeMoveFactory();
    protected RoomChangeMoveFactory roomChangeMoveFactory = new RoomChangeMoveFactory();
    protected ExamSwapMoveFactory examSwapMoveFactory = new ExamSwapMoveFactory();
    protected Map<Exam, List<Move>> cachedExamToMoveMap;
    protected List<Exam> shuffledExamList;
    protected int nextShuffledExamListIndex;

    public void setDecider(Decider decider) {
        super.setDecider(decider);
        this.periodChangeMoveFactory.setDecider(decider);
        this.roomChangeMoveFactory.setDecider(decider);
        this.examSwapMoveFactory.setDecider(decider);
    }

    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.periodChangeMoveFactory.phaseStarted(localSearchSolverPhaseScope);
        this.roomChangeMoveFactory.phaseStarted(localSearchSolverPhaseScope);
        this.examSwapMoveFactory.phaseStarted(localSearchSolverPhaseScope);
        this.createCachedExamToMoveMap(localSearchSolverPhaseScope);
    }

    private void createCachedExamToMoveMap(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        Examination examination = (Examination)localSearchSolverPhaseScope.getWorkingSolution();
        int examListSize = examination.getExamList().size();
        List cachedPeriodChangeMoveList = this.periodChangeMoveFactory.getCachedMoveList();
        List cachedRoomChangeMoveList = this.roomChangeMoveFactory.getCachedMoveList();
        List cachedExamSwapMoveList = this.examSwapMoveFactory.getCachedMoveList();
        this.cachedExamToMoveMap = new HashMap<Exam, List<Move>>(cachedPeriodChangeMoveList.size() + cachedRoomChangeMoveList.size() + cachedExamSwapMoveList.size());
        this.addToCachedExamToMoveMap(examListSize, cachedPeriodChangeMoveList);
        this.addToCachedExamToMoveMap(examListSize, cachedRoomChangeMoveList);
        this.addToCachedExamToMoveMap(examListSize, cachedExamSwapMoveList);
        this.shuffledExamList = new ArrayList<Exam>(this.cachedExamToMoveMap.keySet());
        this.nextShuffledExamListIndex = Integer.MAX_VALUE;
    }

    private void addToCachedExamToMoveMap(int examListSize, List<Move> cachedMoveList) {
        for (Move cachedMove : cachedMoveList) {
            for (Object o : cachedMove.getPlanningEntities()) {
                Exam exam = (Exam)o;
                List<Move> moveList = this.cachedExamToMoveMap.get(exam);
                if (moveList == null) {
                    moveList = new ArrayList<Move>(examListSize);
                    this.cachedExamToMoveMap.put(exam, moveList);
                }
                moveList.add(cachedMove);
            }
        }
    }

    public void beforeDeciding(LocalSearchStepScope localSearchStepScope) {
        this.periodChangeMoveFactory.beforeDeciding(localSearchStepScope);
        this.roomChangeMoveFactory.beforeDeciding(localSearchStepScope);
        this.examSwapMoveFactory.beforeDeciding(localSearchStepScope);
    }

    public Iterator<Move> moveIterator(LocalSearchStepScope localSearchStepScope) {
        if (this.nextShuffledExamListIndex >= this.shuffledExamList.size()) {
            Collections.shuffle(this.shuffledExamList, localSearchStepScope.getWorkingRandom());
            this.nextShuffledExamListIndex = 0;
        }
        Exam exam = this.shuffledExamList.get(this.nextShuffledExamListIndex);
        List<Move> moveList = this.cachedExamToMoveMap.get(exam);
        ++this.nextShuffledExamListIndex;
        return moveList.iterator();
    }

    public void stepTaken(LocalSearchStepScope localSearchStepScope) {
        this.periodChangeMoveFactory.stepTaken(localSearchStepScope);
        this.roomChangeMoveFactory.stepTaken(localSearchStepScope);
        this.examSwapMoveFactory.stepTaken(localSearchStepScope);
    }

    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.periodChangeMoveFactory.phaseEnded(localSearchSolverPhaseScope);
        this.roomChangeMoveFactory.phaseEnded(localSearchSolverPhaseScope);
        this.examSwapMoveFactory.phaseEnded(localSearchSolverPhaseScope);
    }
}

