/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.pas.solver.move;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.examples.pas.domain.Bed;
import org.drools.planner.examples.pas.domain.BedDesignation;
import org.drools.planner.examples.pas.solver.move.PatientAdmissionMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BedDesignationSwapMove
implements Move {
    private BedDesignation leftBedDesignation;
    private BedDesignation rightBedDesignation;

    public BedDesignationSwapMove(BedDesignation leftBedDesignation, BedDesignation rightBedDesignation) {
        this.leftBedDesignation = leftBedDesignation;
        this.rightBedDesignation = rightBedDesignation;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.leftBedDesignation.getBed(), (Object)this.rightBedDesignation.getBed());
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new BedDesignationSwapMove(this.rightBedDesignation, this.leftBedDesignation);
    }

    public void doMove(ScoreDirector scoreDirector) {
        Bed oldLeftBed = this.leftBedDesignation.getBed();
        Bed oldRightBed = this.rightBedDesignation.getBed();
        PatientAdmissionMoveHelper.moveBed(scoreDirector, this.leftBedDesignation, oldRightBed);
        PatientAdmissionMoveHelper.moveBed(scoreDirector, this.rightBedDesignation, oldLeftBed);
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftBedDesignation, this.rightBedDesignation);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Arrays.asList(this.leftBedDesignation.getBed(), this.rightBedDesignation.getBed());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BedDesignationSwapMove) {
            BedDesignationSwapMove other = (BedDesignationSwapMove)o;
            return new EqualsBuilder().append((Object)this.leftBedDesignation, (Object)other.leftBedDesignation).append((Object)this.rightBedDesignation, (Object)other.rightBedDesignation).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftBedDesignation).append((Object)this.rightBedDesignation).toHashCode();
    }

    public String toString() {
        return this.leftBedDesignation + " <=> " + this.rightBedDesignation;
    }
}

