/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solver.ProblemFactChange;
import org.drools.planner.examples.common.swingui.SolutionPanel;
import org.drools.planner.examples.common.swingui.SolverAndPersistenceFrame;
import org.drools.planner.examples.tsp.domain.City;
import org.drools.planner.examples.tsp.domain.TravelingSalesmanTour;
import org.drools.planner.examples.tsp.domain.Visit;
import org.drools.planner.examples.tsp.swingui.TspListPanel;
import org.drools.planner.examples.tsp.swingui.TspWorldPanel;

public class TspPanel
extends SolutionPanel {
    public static final String LOGO_PATH = "/org/drools/planner/examples/tsp/swingui/tspLogo.png";
    private TspWorldPanel tspWorldPanel;
    private TspListPanel tspListPanel;
    private Long nextCityId = null;

    public TspPanel() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        this.tspWorldPanel = new TspWorldPanel(this);
        this.tspWorldPanel.setPreferredSize(PREFERRED_SCROLLABLE_VIEWPORT_SIZE);
        tabbedPane.add("World", this.tspWorldPanel);
        this.tspListPanel = new TspListPanel(this);
        JScrollPane tspListScrollPane = new JScrollPane(this.tspListPanel);
        tabbedPane.add("List", tspListScrollPane);
        this.add((Component)tabbedPane, "Center");
    }

    public boolean isWrapInScrollPane() {
        return false;
    }

    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    public TravelingSalesmanTour getTravelingSalesmanTour() {
        return (TravelingSalesmanTour)this.solutionBusiness.getSolution();
    }

    public void resetPanel(Solution solution) {
        TravelingSalesmanTour travelingSalesmanTour = (TravelingSalesmanTour)solution;
        this.tspWorldPanel.resetPanel(travelingSalesmanTour);
        this.tspListPanel.resetPanel(travelingSalesmanTour);
        this.resetNextCityId();
    }

    private void resetNextCityId() {
        long highestCityId = 0L;
        for (City city : this.getTravelingSalesmanTour().getCityList()) {
            if (highestCityId >= city.getId()) continue;
            highestCityId = city.getId();
        }
        this.nextCityId = highestCityId + 1L;
    }

    public void updatePanel(Solution solution) {
        TravelingSalesmanTour travelingSalesmanTour = (TravelingSalesmanTour)solution;
        this.tspWorldPanel.updatePanel(travelingSalesmanTour);
        this.tspListPanel.updatePanel(travelingSalesmanTour);
    }

    public void doMove(Move move) {
        this.solutionBusiness.doMove(move);
    }

    public SolverAndPersistenceFrame getWorkflowFrame() {
        return this.solverAndPersistenceFrame;
    }

    public void insertCityAndVisit(double longitude, double latitude) {
        final City newCity = new City();
        newCity.setId(this.nextCityId);
        Long l = this.nextCityId;
        Long l2 = this.nextCityId = Long.valueOf(this.nextCityId + 1L);
        newCity.setLongitude(longitude);
        newCity.setLatitude(latitude);
        this.logger.info("Scheduling insertion of newCity ({}).", (Object)newCity);
        this.solutionBusiness.doProblemFactChange(new ProblemFactChange(){

            public void doChange(ScoreDirector scoreDirector) {
                TravelingSalesmanTour solution = (TravelingSalesmanTour)scoreDirector.getWorkingSolution();
                scoreDirector.beforeProblemFactAdded((Object)newCity);
                solution.getCityList().add(newCity);
                scoreDirector.afterProblemFactAdded((Object)newCity);
                Visit newVisit = new Visit();
                newVisit.setId(newCity.getId());
                newVisit.setCity(newCity);
                scoreDirector.beforeEntityAdded((Object)newVisit);
                solution.getVisitList().add(newVisit);
                scoreDirector.afterEntityAdded((Object)newVisit);
            }
        });
        this.updatePanel(this.solutionBusiness.getSolution());
    }
}

