/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.common.app;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.drools.planner.benchmark.api.PlannerBenchmark;
import org.drools.planner.benchmark.config.PlannerBenchmarkConfig;
import org.drools.planner.benchmark.config.SolverBenchmarkConfig;
import org.drools.planner.benchmark.config.XmlPlannerBenchmarkFactory;
import org.drools.planner.config.termination.TerminationConfig;
import org.drools.planner.examples.common.app.LoggingTest;

public abstract class PlannerBenchmarkTest
extends LoggingTest {
    private static final int MAXIMUM_SOLVER_BENCHMARK_SIZE = 6;
    private static final long WARM_UP_SECONDS_SPEND = 5L;
    private static final long MAXIMUM_SECONDS_SPEND = 30L;

    protected abstract String createBenchmarkConfigResource();

    protected void runBenchmarkTest(File unsolvedDataFile) {
        XmlPlannerBenchmarkFactory plannerBenchmarkFactory = this.buildPlannerBenchmarkFactory(unsolvedDataFile);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        plannerBenchmark.benchmark();
    }

    private XmlPlannerBenchmarkFactory buildPlannerBenchmarkFactory(File unsolvedDataFile) {
        XmlPlannerBenchmarkFactory benchmarkFactory = new XmlPlannerBenchmarkFactory();
        benchmarkFactory.configure(this.createBenchmarkConfigResource());
        PlannerBenchmarkConfig plannerBenchmarkConfig = benchmarkFactory.getPlannerBenchmarkConfig();
        plannerBenchmarkConfig.setBenchmarkDirectory(new File("target/test/data/nqueens"));
        plannerBenchmarkConfig.setWarmUpHoursSpend(Long.valueOf(0L));
        plannerBenchmarkConfig.setWarmUpMinutesSpend(Long.valueOf(0L));
        plannerBenchmarkConfig.setWarmUpSecondsSpend(Long.valueOf(5L));
        plannerBenchmarkConfig.setWarmUpTimeMillisSpend(Long.valueOf(0L));
        List solverBenchmarkConfigList = plannerBenchmarkConfig.getSolverBenchmarkConfigList();
        if (solverBenchmarkConfigList.size() > 6) {
            solverBenchmarkConfigList = solverBenchmarkConfigList.subList(0, 6);
            plannerBenchmarkConfig.setSolverBenchmarkConfigList(solverBenchmarkConfigList);
        }
        long maximumSecondsSpendPerSolverBenchmark = 30L / (long)solverBenchmarkConfigList.size();
        SolverBenchmarkConfig inheritedSolverBenchmarkConfig = plannerBenchmarkConfig.getInheritedSolverBenchmarkConfig();
        if (inheritedSolverBenchmarkConfig != null) {
            inheritedSolverBenchmarkConfig.getProblemBenchmarksConfig().setInputSolutionFileList(Collections.singletonList(unsolvedDataFile));
            TerminationConfig terminationConfig = new TerminationConfig();
            terminationConfig.setMaximumSecondsSpend(Long.valueOf(maximumSecondsSpendPerSolverBenchmark));
            inheritedSolverBenchmarkConfig.getSolverConfig().setTerminationConfig(terminationConfig);
        }
        for (SolverBenchmarkConfig solverBenchmarkConfig : solverBenchmarkConfigList) {
            solverBenchmarkConfig.getProblemBenchmarksConfig().setInputSolutionFileList(null);
            solverBenchmarkConfig.getSolverConfig().setTerminationConfig(new TerminationConfig());
        }
        return benchmarkFactory;
    }
}

