/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.drools.planner.examples.cloudbalancing.app.CloudBalancingApp;
import org.drools.planner.examples.common.swingui.TangoColors;
import org.drools.planner.examples.curriculumcourse.app.CurriculumCourseApp;
import org.drools.planner.examples.examination.app.ExaminationApp;
import org.drools.planner.examples.machinereassignment.app.MachineReassignmentApp;
import org.drools.planner.examples.manners2009.app.Manners2009App;
import org.drools.planner.examples.nqueens.app.NQueensApp;
import org.drools.planner.examples.nurserostering.app.NurseRosteringApp;
import org.drools.planner.examples.pas.app.PatientAdmissionScheduleApp;
import org.drools.planner.examples.travelingtournament.app.smart.SmartTravelingTournamentApp;
import org.drools.planner.examples.tsp.app.TspApp;
import org.drools.planner.examples.vehiclerouting.app.VehicleRoutingApp;

public class DroolsPlannerExamplesApp
extends JFrame {
    private JTextArea descriptionTextArea;

    public static void main(String[] args) {
        DroolsPlannerExamplesApp droolsPlannerExamplesApp = new DroolsPlannerExamplesApp();
        droolsPlannerExamplesApp.pack();
        droolsPlannerExamplesApp.setLocationRelativeTo(null);
        droolsPlannerExamplesApp.setVisible(true);
    }

    public DroolsPlannerExamplesApp() {
        super("Drools Planner examples");
        this.setContentPane(this.createContentPane());
        this.setDefaultCloseOperation(3);
    }

    private Container createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout(10, 10));
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel titleLabel = new JLabel("Which example do you want to see?", 0);
        titleLabel.setFont(titleLabel.getFont().deriveFont(20.0f));
        contentPane.add((Component)titleLabel, "North");
        JScrollPane examplesScrollPane = new JScrollPane(this.createExamplesPanel());
        examplesScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        examplesScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        contentPane.add((Component)examplesScrollPane, "Center");
        contentPane.add((Component)this.createDescriptionPanel(), "South");
        return contentPane;
    }

    private JPanel createExamplesPanel() {
        JPanel examplesPanel = new JPanel();
        examplesPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GroupLayout layout = new GroupLayout(examplesPanel);
        examplesPanel.setLayout(layout);
        JPanel toyExamplesPanel = this.createToyExamplesPanel();
        JPanel realExamplesPanel = this.createRealExamplesPanel();
        JPanel difficultExamplesPanel = this.createDifficultExamplesPanel();
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(toyExamplesPanel).addGap(10).addComponent(realExamplesPanel).addGap(10).addComponent(difficultExamplesPanel));
        layout.setVerticalGroup(layout.createParallelGroup().addComponent(toyExamplesPanel).addComponent(realExamplesPanel).addComponent(difficultExamplesPanel));
        return examplesPanel;
    }

    private JPanel createToyExamplesPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 1, 5, 5));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Toy examples");
        titledBorder.setTitleColor(TangoColors.CHAMELEON_3);
        panel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        panel.add(this.createExampleButton("N queens", "Place queens on a chessboard.\n\nNo 2 queens must be able to attack each other.", "/org/drools/planner/examples/nqueens/swingui/nqueensLogo.png", new Runnable(){

            public void run() {
                new NQueensApp().init(false);
            }
        }));
        panel.add(this.createExampleButton("Cloud balancing", "Assign processes to computers.\n\nEach computer must have enough hardware to run all of it's processes.\nEach computer used inflicts a maintenance cost.", "/org/drools/planner/examples/cloudbalancing/swingui/cloudBalancingLogo.png", new Runnable(){

            public void run() {
                new CloudBalancingApp().init(false);
            }
        }));
        panel.add(this.createExampleButton("Traveling salesman", "Official competition name: TSP - Traveling salesman problem\nDetermine the order in which to visit all cities.\n\nFind the shortest route to visit all cities.", "/org/drools/planner/examples/tsp/swingui/tspLogo.png", new Runnable(){

            public void run() {
                new TspApp().init(false);
            }
        }));
        panel.add(this.createExampleButton("Manners 2009", "A much larger variant of the classic Miss Manners problem.\nAssign guests to seats at tables.", null, new Runnable(){

            public void run() {
                new Manners2009App().init(false);
            }
        }));
        return panel;
    }

    private JPanel createRealExamplesPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 1, 5, 5));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Real examples");
        titledBorder.setTitleColor(TangoColors.BUTTER_3);
        panel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        panel.add(this.createExampleButton("Course timetabling", "Official competition name: ITC 2007 track3 - Curriculum course scheduling\nAssign lectures to periods and rooms.", null, new Runnable(){

            public void run() {
                new CurriculumCourseApp().init(false);
            }
        }));
        panel.add(this.createExampleButton("Machine reassignment", "Official competition name: Google ROADEF 2012 - Machine reassignment.\nReassign processes to machines.", "/org/drools/planner/examples/machinereassignment/swingui/machineReassignmentLogo.png", new Runnable(){

            public void run() {
                new MachineReassignmentApp().init(false);
            }
        }));
        panel.add(this.createExampleButton("Vehicle routing", "Official competition name: Capacitated vehicle routing problem (CRVP).\nPick up all items of all customers with a few vehicles in the shortest route possible.", "/org/drools/planner/examples/vehiclerouting/swingui/vehicleRoutingLogo.png", new Runnable(){

            public void run() {
                new VehicleRoutingApp().init(false);
            }
        }));
        panel.add(this.createExampleButton("Hospital bed planning", "Official competition name: PAS - Patient admission scheduling\nAssign patients to beds.", null, new Runnable(){

            public void run() {
                new PatientAdmissionScheduleApp().init(false);
            }
        }));
        return panel;
    }

    private JPanel createDifficultExamplesPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 1, 5, 5));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Difficult examples");
        titledBorder.setTitleColor(TangoColors.SCARLET_3);
        panel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        panel.add(this.createExampleButton("Exam timetabling", "Official competition name: ITC 2007 track1 - Examination timetabling\nAssign exams to timeslots and rooms.", null, new Runnable(){

            public void run() {
                new ExaminationApp().init(false);
            }
        }));
        panel.add(this.createExampleButton("Employee rostering", "Official competition name: INRC2010 - Nurse rostering\nAssign shifts to employees.", "/org/drools/planner/examples/nurserostering/swingui/nurseRosteringLogo.png", new Runnable(){

            public void run() {
                new NurseRosteringApp().init(false);
            }
        }));
        panel.add(this.createExampleButton("Sport scheduling", "Official competition name: TTP - Traveling tournament problem\nAssign matches to days.", null, new Runnable(){

            public void run() {
                new SmartTravelingTournamentApp().init(false);
            }
        }));
        panel.add(new JPanel());
        return panel;
    }

    private JButton createDisabledExampleButton(String title, String description, String iconResource) {
        JButton exampleButton = this.createExampleButton(title, description, iconResource, null);
        exampleButton.setEnabled(false);
        return exampleButton;
    }

    private JButton createExampleButton(String title, final String description, String iconResource, final Runnable runnable) {
        ImageIcon icon = iconResource == null ? null : new ImageIcon(this.getClass().getResource(iconResource));
        JButton button = new JButton(new AbstractAction(title, icon){

            public void actionPerformed(ActionEvent e) {
                runnable.run();
            }
        });
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        button.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                DroolsPlannerExamplesApp.this.descriptionTextArea.setText(description);
            }

            public void mouseExited(MouseEvent e) {
                DroolsPlannerExamplesApp.this.descriptionTextArea.setText("");
            }
        });
        return button;
    }

    private JPanel createDescriptionPanel() {
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.add((Component)new JLabel("Description"), "North");
        this.descriptionTextArea = new JTextArea(8, 80);
        this.descriptionTextArea.setEditable(false);
        descriptionPanel.add((Component)new JScrollPane(this.descriptionTextArea, 22, 31), "Center");
        return descriptionPanel;
    }
}

