/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.common.business;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.score.constraint.ConstraintOccurrence;
import org.drools.planner.core.score.constraint.ConstraintType;
import org.drools.planner.core.score.constraint.DoubleConstraintOccurrence;
import org.drools.planner.core.score.constraint.IntConstraintOccurrence;
import org.drools.planner.core.score.constraint.LongConstraintOccurrence;
import org.drools.planner.core.score.constraint.UnweightedConstraintOccurrence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoreDetail
implements Comparable<ScoreDetail> {
    private String ruleId;
    private ConstraintType constraintType;
    private Set<ConstraintOccurrence> constraintOccurrenceSet = new HashSet<ConstraintOccurrence>();
    private double scoreTotal = 0.0;

    public ScoreDetail(String ruleId, ConstraintType constraintType) {
        this.ruleId = ruleId;
        this.constraintType = constraintType;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public Set<ConstraintOccurrence> getConstraintOccurrenceSet() {
        return this.constraintOccurrenceSet;
    }

    public int getOccurrenceSize() {
        return this.constraintOccurrenceSet.size();
    }

    public double getScoreTotal() {
        return this.scoreTotal;
    }

    public void addConstraintOccurrence(ConstraintOccurrence constraintOccurrence) {
        double occurrenceScore;
        boolean added = this.constraintOccurrenceSet.add(constraintOccurrence);
        if (!added) {
            throw new IllegalArgumentException("Add the same constraintOccurrence (" + constraintOccurrence + ") twice.");
        }
        if (constraintOccurrence instanceof IntConstraintOccurrence) {
            occurrenceScore = ((IntConstraintOccurrence)constraintOccurrence).getWeight();
        } else if (constraintOccurrence instanceof DoubleConstraintOccurrence) {
            occurrenceScore = ((DoubleConstraintOccurrence)constraintOccurrence).getWeight();
        } else if (constraintOccurrence instanceof LongConstraintOccurrence) {
            occurrenceScore = ((LongConstraintOccurrence)constraintOccurrence).getWeight();
        } else if (constraintOccurrence instanceof UnweightedConstraintOccurrence) {
            occurrenceScore = 1.0;
        } else {
            throw new IllegalStateException("Cannot determine occurrenceScore of ConstraintOccurrence class: " + constraintOccurrence.getClass());
        }
        this.scoreTotal += occurrenceScore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ScoreDetail) {
            ScoreDetail other = (ScoreDetail)o;
            return new EqualsBuilder().append((Object)this.ruleId, (Object)other.ruleId).append((Object)this.constraintType, (Object)other.constraintType).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.ruleId).append((Object)this.constraintType).toHashCode();
    }

    @Override
    public int compareTo(ScoreDetail other) {
        return new CompareToBuilder().append((Object)this.constraintType, (Object)other.constraintType).append((Object)this.ruleId, (Object)other.ruleId).toComparison();
    }

    public String toString() {
        return this.ruleId + "/" + this.constraintType + " (" + this.getOccurrenceSize() + ") = " + this.scoreTotal;
    }

    public String buildConstraintOccurrenceListText() {
        ArrayList<ConstraintOccurrence> constraintOccurrenceList = new ArrayList<ConstraintOccurrence>(this.constraintOccurrenceSet);
        Collections.sort(constraintOccurrenceList);
        StringBuilder text = new StringBuilder(constraintOccurrenceList.size() * 80);
        for (ConstraintOccurrence constraintOccurrence : constraintOccurrenceList) {
            text.append(constraintOccurrence.toString()).append("\n");
        }
        return text.toString();
    }
}

