/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.manners2009.solver.move;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.examples.manners2009.domain.Seat;
import org.drools.planner.examples.manners2009.domain.SeatDesignation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeatDesignationSwapMove
implements Move {
    private SeatDesignation leftSeatDesignation;
    private SeatDesignation rightSeatDesignation;

    public SeatDesignationSwapMove(SeatDesignation leftSeatDesignation, SeatDesignation rightSeatDesignation) {
        this.leftSeatDesignation = leftSeatDesignation;
        this.rightSeatDesignation = rightSeatDesignation;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.leftSeatDesignation.getSeat(), (Object)this.rightSeatDesignation.getSeat());
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new SeatDesignationSwapMove(this.rightSeatDesignation, this.leftSeatDesignation);
    }

    public void doMove(ScoreDirector scoreDirector) {
        Seat oldLeftSeat = this.leftSeatDesignation.getSeat();
        Seat oldRightSeat = this.rightSeatDesignation.getSeat();
        SeatDesignationSwapMove.moveSeat(scoreDirector, this.leftSeatDesignation, oldRightSeat);
        SeatDesignationSwapMove.moveSeat(scoreDirector, this.rightSeatDesignation, oldLeftSeat);
    }

    private static void moveSeat(ScoreDirector scoreDirector, SeatDesignation seatDesignation, Seat toSeat) {
        scoreDirector.beforeVariableChanged((Object)seatDesignation, "seat");
        seatDesignation.setSeat(toSeat);
        scoreDirector.afterVariableChanged((Object)seatDesignation, "seat");
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftSeatDesignation, this.rightSeatDesignation);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Arrays.asList(this.leftSeatDesignation.getSeat(), this.rightSeatDesignation.getSeat());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SeatDesignationSwapMove) {
            SeatDesignationSwapMove other = (SeatDesignationSwapMove)o;
            return new EqualsBuilder().append((Object)this.leftSeatDesignation, (Object)other.leftSeatDesignation).append((Object)this.rightSeatDesignation, (Object)other.rightSeatDesignation).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftSeatDesignation).append((Object)this.rightSeatDesignation).toHashCode();
    }

    public String toString() {
        return this.leftSeatDesignation + " <=> " + this.rightSeatDesignation;
    }
}

