/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.swingui;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import org.apache.commons.lang.ObjectUtils;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solver.ProblemFactChange;
import org.drools.planner.examples.common.swingui.SolutionPanel;
import org.drools.planner.examples.nurserostering.domain.Employee;
import org.drools.planner.examples.nurserostering.domain.NurseRoster;
import org.drools.planner.examples.nurserostering.domain.Shift;
import org.drools.planner.examples.nurserostering.domain.ShiftAssignment;
import org.drools.planner.examples.nurserostering.domain.ShiftDate;
import org.drools.planner.examples.nurserostering.solver.move.EmployeeChangeMove;
import org.drools.planner.examples.nurserostering.swingui.EmployeePanel;

public class NurseRosteringPanel
extends SolutionPanel {
    public static final String LOGO_PATH = "/org/drools/planner/examples/nurserostering/swingui/nurseRosteringLogo.png";
    private JPanel employeeListPanel;
    private EmployeePanel unassignedPanel;
    private Map<Employee, EmployeePanel> employeeToPanelMap;
    private Map<ShiftAssignment, EmployeePanel> shiftAssignmentToPanelMap;

    public NurseRosteringPanel() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        this.createEmployeeListPanel();
        JPanel headerPanel = this.createHeaderPanel();
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(headerPanel).addComponent(this.employeeListPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(headerPanel, -2, -2, -2).addComponent(this.employeeListPanel, -2, -2, -2));
    }

    private JPanel createHeaderPanel() {
        JPanel headerPanel = new JPanel();
        return headerPanel;
    }

    private void createEmployeeListPanel() {
        this.employeeListPanel = new JPanel();
        this.employeeListPanel.setLayout(new BoxLayout(this.employeeListPanel, 1));
        this.unassignedPanel = new EmployeePanel(this, Collections.<ShiftDate>emptyList(), Collections.<Shift>emptyList(), null);
        this.employeeListPanel.add(this.unassignedPanel);
        this.employeeToPanelMap = new LinkedHashMap<Employee, EmployeePanel>();
        this.employeeToPanelMap.put(null, this.unassignedPanel);
        this.shiftAssignmentToPanelMap = new LinkedHashMap<ShiftAssignment, EmployeePanel>();
    }

    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    public NurseRoster getNurseRoster() {
        return (NurseRoster)this.solutionBusiness.getSolution();
    }

    public void resetPanel(Solution solution) {
        for (EmployeePanel employeePanel : this.employeeToPanelMap.values()) {
            if (employeePanel.getEmployee() == null) continue;
            this.employeeListPanel.remove(employeePanel);
        }
        this.employeeToPanelMap.clear();
        this.employeeToPanelMap.put(null, this.unassignedPanel);
        this.shiftAssignmentToPanelMap.clear();
        this.unassignedPanel.clearShiftAssignments();
        this.updatePanel(solution);
    }

    public void updatePanel(Solution solution) {
        EmployeePanel deadEmployeePanel;
        NurseRoster nurseRoster = (NurseRoster)solution;
        List<ShiftDate> shiftDateList = nurseRoster.getShiftDateList();
        List<Shift> shiftList = nurseRoster.getShiftList();
        this.unassignedPanel.setShiftDateListAndShiftList(shiftDateList, shiftList);
        LinkedHashSet<Employee> deadEmployeeSet = new LinkedHashSet<Employee>(this.employeeToPanelMap.keySet());
        deadEmployeeSet.remove(null);
        for (Employee employee : nurseRoster.getEmployeeList()) {
            deadEmployeeSet.remove(employee);
            EmployeePanel employeePanel = this.employeeToPanelMap.get(employee);
            if (employeePanel != null) continue;
            employeePanel = new EmployeePanel(this, shiftDateList, shiftList, employee);
            this.employeeListPanel.add(employeePanel);
            this.employeeToPanelMap.put(employee, employeePanel);
        }
        LinkedHashSet<ShiftAssignment> deadShiftAssignmentSet = new LinkedHashSet<ShiftAssignment>(this.shiftAssignmentToPanelMap.keySet());
        for (ShiftAssignment shiftAssignment : nurseRoster.getShiftAssignmentList()) {
            deadShiftAssignmentSet.remove(shiftAssignment);
            EmployeePanel employeePanel = this.shiftAssignmentToPanelMap.get(shiftAssignment);
            Employee employee = shiftAssignment.getEmployee();
            if (employeePanel != null && !ObjectUtils.equals((Object)employeePanel.getEmployee(), (Object)employee)) {
                this.shiftAssignmentToPanelMap.remove(shiftAssignment);
                employeePanel.removeShiftAssignment(shiftAssignment);
                employeePanel = null;
            }
            if (employeePanel != null) continue;
            employeePanel = this.employeeToPanelMap.get(employee);
            employeePanel.addShiftAssignment(shiftAssignment);
            this.shiftAssignmentToPanelMap.put(shiftAssignment, employeePanel);
        }
        for (ShiftAssignment deadShiftAssignment : deadShiftAssignmentSet) {
            deadEmployeePanel = this.shiftAssignmentToPanelMap.remove(deadShiftAssignment);
            deadEmployeePanel.removeShiftAssignment(deadShiftAssignment);
        }
        for (Employee deadEmployee : deadEmployeeSet) {
            deadEmployeePanel = this.employeeToPanelMap.remove(deadEmployee);
            this.employeeListPanel.remove(deadEmployeePanel);
        }
        for (EmployeePanel employeePanel : this.employeeToPanelMap.values()) {
            employeePanel.update();
        }
    }

    public void deleteEmployee(final Employee employee) {
        this.logger.info("Scheduling delete of employee ({}).", (Object)employee);
        this.solutionBusiness.doProblemFactChange(new ProblemFactChange(){

            public void doChange(ScoreDirector scoreDirector) {
                NurseRoster nurseRoster = (NurseRoster)scoreDirector.getWorkingSolution();
                for (ShiftAssignment shiftAssignment : nurseRoster.getShiftAssignmentList()) {
                    if (!ObjectUtils.equals((Object)shiftAssignment.getEmployee(), (Object)employee)) continue;
                    scoreDirector.beforeEntityRemoved((Object)shiftAssignment);
                    shiftAssignment.setEmployee(null);
                    scoreDirector.afterEntityRemoved((Object)shiftAssignment);
                }
                Iterator<Employee> it = nurseRoster.getEmployeeList().iterator();
                while (it.hasNext()) {
                    Employee workingEmployee = it.next();
                    if (!ObjectUtils.equals((Object)workingEmployee, (Object)employee)) continue;
                    scoreDirector.beforeProblemFactRemoved((Object)workingEmployee);
                    it.remove();
                    scoreDirector.beforeProblemFactRemoved((Object)employee);
                    break;
                }
            }
        });
        this.updatePanel(this.solutionBusiness.getSolution());
    }

    public void moveShiftAssignmentToEmployee(ShiftAssignment shiftAssignment, Employee toEmployee) {
        this.solutionBusiness.doMove(new EmployeeChangeMove(shiftAssignment, toEmployee));
        this.solverAndPersistenceFrame.resetScreen();
    }
}

