/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.traindesign.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.traindesign.domain.RailArc;
import org.drools.planner.examples.traindesign.domain.solver.RailNodeShortestPath;
import org.drools.planner.examples.traindesign.domain.solver.RailPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="RailNode")
public class RailNode
extends AbstractPersistable {
    private String code;
    private int blockSwapCost;
    private List<RailArc> originatingRailArcList;
    @XStreamOmitField
    private Map<RailNode, RailNodeShortestPath> shortestPathMap;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getBlockSwapCost() {
        return this.blockSwapCost;
    }

    public void setBlockSwapCost(int blockSwapCost) {
        this.blockSwapCost = blockSwapCost;
    }

    public List<RailArc> getOriginatingRailArcList() {
        return this.originatingRailArcList;
    }

    public void setOriginatingRailArcList(List<RailArc> originatingRailArcList) {
        this.originatingRailArcList = originatingRailArcList;
    }

    public Map<RailNode, RailNodeShortestPath> getShortestPathMap() {
        return this.shortestPathMap;
    }

    public RailNodeShortestPath getShortestPathTo(RailNode other) {
        return this.shortestPathMap.get(other);
    }

    public void setShortestPathMap(Map<RailNode, RailNodeShortestPath> shortestPathMap) {
        this.shortestPathMap = shortestPathMap;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public void initializeShortestPathMap(List<RailNode> railNodeList) {
        this.shortestPathMap = new HashMap<RailNode, RailNodeShortestPath>(railNodeList.size());
        ArrayList<RailNodeShortestPath> unvisitedShortestPathList = new ArrayList<RailNodeShortestPath>(railNodeList.size());
        RailNodeShortestPath originShortestPath = new RailNodeShortestPath();
        originShortestPath.setOrigin(this);
        originShortestPath.setDestination(this);
        originShortestPath.setDistance(0);
        originShortestPath.resetRailPathList();
        RailPath originRailPath = new RailPath(new ArrayList<RailArc>(0));
        originShortestPath.addRailPath(originRailPath);
        this.shortestPathMap.put(this, originShortestPath);
        unvisitedShortestPathList.add(originShortestPath);
        while (!unvisitedShortestPathList.isEmpty()) {
            RailNodeShortestPath campingShortestPath = (RailNodeShortestPath)unvisitedShortestPathList.remove(0);
            for (RailArc nextRailArc : campingShortestPath.getDestination().getOriginatingRailArcList()) {
                RailNode nextNode = nextRailArc.getDestination();
                int nextDistance = campingShortestPath.getDistance() + nextRailArc.getDistance();
                RailNodeShortestPath nextShortestPath = this.shortestPathMap.get(nextNode);
                if (nextShortestPath == null) {
                    nextShortestPath = new RailNodeShortestPath();
                    nextShortestPath.setOrigin(this);
                    nextShortestPath.setDestination(nextNode);
                    nextShortestPath.setDistance(Integer.MAX_VALUE);
                    this.shortestPathMap.put(nextNode, nextShortestPath);
                    unvisitedShortestPathList.add(nextShortestPath);
                }
                if (nextDistance > nextShortestPath.getDistance()) continue;
                if (nextDistance < nextShortestPath.getDistance()) {
                    nextShortestPath.setDistance(nextDistance);
                    nextShortestPath.resetRailPathList();
                }
                for (RailPath campingRailPath : campingShortestPath.getRailPathList()) {
                    ArrayList<RailArc> railArcList = new ArrayList<RailArc>(campingRailPath.getRailArcList());
                    railArcList.add(nextRailArc);
                    RailPath nextRailPath = new RailPath(railArcList);
                    nextShortestPath.addRailPath(nextRailPath);
                }
            }
            Collections.sort(unvisitedShortestPathList, new Comparator<RailNodeShortestPath>(){

                @Override
                public int compare(RailNodeShortestPath a, RailNodeShortestPath b) {
                    return new CompareToBuilder().append(a.getDistance(), b.getDistance()).append(a.getRailPathList().size(), b.getRailPathList().size()).append((Object)a.getId(), (Object)b.getId()).toComparison();
                }
            });
        }
    }
}

