/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.vehiclerouting.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.drools.planner.core.score.buildin.hardandsoft.HardAndSoftScore;
import org.drools.planner.examples.common.swingui.TangoColors;
import org.drools.planner.examples.common.swingui.latitudelongitude.LatitudeLongitudeTranslator;
import org.drools.planner.examples.vehiclerouting.domain.VrpCustomer;
import org.drools.planner.examples.vehiclerouting.domain.VrpDepot;
import org.drools.planner.examples.vehiclerouting.domain.VrpLocation;
import org.drools.planner.examples.vehiclerouting.domain.VrpSchedule;
import org.drools.planner.examples.vehiclerouting.domain.VrpVehicle;
import org.drools.planner.examples.vehiclerouting.swingui.VehicleRoutingPanel;

public class VehicleRoutingWorldPanel
extends JPanel {
    private static final int TEXT_SIZE = 12;
    private static final String IMAGE_PATH_PREFIX = "/org/drools/planner/examples/vehiclerouting/swingui/";
    private ImageIcon depotImageIcon;
    private ImageIcon[] vehicleImageIcons;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private final VehicleRoutingPanel vehicleRoutingPanel;
    private BufferedImage canvas = null;
    private LatitudeLongitudeTranslator translator = null;

    public VehicleRoutingWorldPanel(VehicleRoutingPanel vehicleRoutingPanel) {
        this.vehicleRoutingPanel = vehicleRoutingPanel;
        this.depotImageIcon = new ImageIcon(this.getClass().getResource("/org/drools/planner/examples/vehiclerouting/swingui/depot.png"));
        this.vehicleImageIcons = new ImageIcon[]{new ImageIcon(this.getClass().getResource("/org/drools/planner/examples/vehiclerouting/swingui/vehicleChameleon.png")), new ImageIcon(this.getClass().getResource("/org/drools/planner/examples/vehiclerouting/swingui/vehicleButter.png")), new ImageIcon(this.getClass().getResource("/org/drools/planner/examples/vehiclerouting/swingui/vehicleSkyBlue.png")), new ImageIcon(this.getClass().getResource("/org/drools/planner/examples/vehiclerouting/swingui/vehicleChocolate.png")), new ImageIcon(this.getClass().getResource("/org/drools/planner/examples/vehiclerouting/swingui/vehiclePlum.png"))};
        if (this.vehicleImageIcons.length != TangoColors.SEQUENCE_1.length) {
            throw new IllegalStateException("The vehicleImageIcons length (" + this.vehicleImageIcons.length + ") should be equal to the TangoColors.SEQUENCE length (" + TangoColors.SEQUENCE_1.length + ").");
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                VrpSchedule schedule = VehicleRoutingWorldPanel.this.vehicleRoutingPanel.getSchedule();
                if (schedule != null) {
                    VehicleRoutingWorldPanel.this.resetPanel(schedule);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (VehicleRoutingWorldPanel.this.translator != null) {
                    double longitude = VehicleRoutingWorldPanel.this.translator.translateXToLongitude(e.getX());
                    double latitude = VehicleRoutingWorldPanel.this.translator.translateYToLatitude(e.getY());
                    VehicleRoutingWorldPanel.this.vehicleRoutingPanel.insertLocationAndCustomer(longitude, latitude);
                }
            }
        });
    }

    public void resetPanel(VrpSchedule schedule) {
        this.translator = new LatitudeLongitudeTranslator();
        for (VrpLocation location : schedule.getLocationList()) {
            this.translator.addCoordinates(location.getLatitude(), location.getLongitude());
        }
        Dimension size = this.getSize();
        double width = size.getWidth();
        double height = size.getHeight();
        this.translator.prepareFor(width, height);
        Graphics g = this.createCanvas(width, height);
        g.setColor(TangoColors.ORANGE_2);
        g.setFont(g.getFont().deriveFont(12.0f));
        for (VrpCustomer customer : schedule.getCustomerList()) {
            VrpLocation location = customer.getLocation();
            int x = this.translator.translateLongitudeToX(location.getLongitude());
            int y = this.translator.translateLatitudeToY(location.getLatitude());
            g.fillRect(x - 1, y - 1, 3, 3);
            g.drawString(Integer.toString(customer.getDemand()), x + 3, y - 3);
        }
        g.setColor(TangoColors.ALUMINIUM_4);
        for (VrpDepot depot : schedule.getDepotList()) {
            int x = this.translator.translateLongitudeToX(depot.getLocation().getLongitude());
            int y = this.translator.translateLatitudeToY(depot.getLocation().getLatitude());
            g.fillRect(x - 2, y - 2, 5, 5);
            g.drawImage(this.depotImageIcon.getImage(), x - this.depotImageIcon.getIconWidth() / 2, y - 2 - this.depotImageIcon.getIconHeight(), this);
        }
        int colorIndex = 0;
        for (VrpVehicle vehicle : schedule.getVehicleList()) {
            int y;
            g.setColor(TangoColors.SEQUENCE_2[colorIndex]);
            VrpCustomer vehicleInfoCustomer = null;
            int longestNonDepotDistance = -1;
            int load = 0;
            for (VrpCustomer customer : schedule.getCustomerList()) {
                if (customer.getPreviousAppearance() == null || customer.getVehicle() != vehicle) continue;
                load += customer.getDemand();
                VrpLocation previousLocation = customer.getPreviousAppearance().getLocation();
                int previousX = this.translator.translateLongitudeToX(previousLocation.getLongitude());
                int previousY = this.translator.translateLatitudeToY(previousLocation.getLatitude());
                VrpLocation location = customer.getLocation();
                int x = this.translator.translateLongitudeToX(location.getLongitude());
                y = this.translator.translateLatitudeToY(location.getLatitude());
                g.drawLine(previousX, previousY, x, y);
                int distance = customer.getDistanceToPreviousAppearance();
                if (customer.getPreviousAppearance() instanceof VrpCustomer) {
                    if (longestNonDepotDistance < distance) {
                        longestNonDepotDistance = distance;
                        vehicleInfoCustomer = customer;
                    }
                } else if (vehicleInfoCustomer == null) {
                    vehicleInfoCustomer = customer;
                }
                boolean needsBackToVehicleLineDraw = true;
                for (VrpCustomer trailingCustomer : schedule.getCustomerList()) {
                    if (trailingCustomer.getPreviousAppearance() != customer) continue;
                    needsBackToVehicleLineDraw = false;
                    break;
                }
                if (!needsBackToVehicleLineDraw) continue;
                VrpLocation vehicleLocation = vehicle.getLocation();
                int vehicleX = this.translator.translateLongitudeToX(vehicleLocation.getLongitude());
                int vehicleY = this.translator.translateLatitudeToY(vehicleLocation.getLatitude());
                g.drawLine(x, y, vehicleX, vehicleY);
            }
            if (vehicleInfoCustomer != null) {
                if (load > vehicle.getCapacity()) {
                    g.setColor(TangoColors.SCARLET_2);
                }
                VrpLocation previousLocation = vehicleInfoCustomer.getPreviousAppearance().getLocation();
                VrpLocation location = vehicleInfoCustomer.getLocation();
                double longitude = (previousLocation.getLongitude() + location.getLongitude()) / 2.0;
                int x = this.translator.translateLongitudeToX(longitude);
                double latitude = (previousLocation.getLatitude() + location.getLatitude()) / 2.0;
                y = this.translator.translateLatitudeToY(latitude);
                boolean ascending = previousLocation.getLongitude() < location.getLongitude() ^ previousLocation.getLatitude() < location.getLatitude();
                ImageIcon vehicleImageIcon = this.vehicleImageIcons[colorIndex];
                int vehicleInfoHeight = vehicleImageIcon.getIconHeight() + 2 + 12;
                g.drawImage(vehicleImageIcon.getImage(), x + 1, ascending ? y - vehicleInfoHeight - 1 : y + 1, this);
                g.drawString(load + " / " + vehicle.getCapacity(), x + 1, ascending ? y - 1 : y + vehicleInfoHeight + 1);
            }
            colorIndex = (colorIndex + 1) % TangoColors.SEQUENCE_2.length;
        }
        g.setColor(TangoColors.ALUMINIUM_4);
        g.fillRect(5, (int)height - 12 - 12 - 6, 5, 5);
        g.drawString("Depot", 15, (int)height - 10 - 12);
        g.setColor(TangoColors.ORANGE_2);
        g.fillRect(6, (int)height - 6 - 6, 3, 3);
        g.drawString("Customer demand", 15, (int)height - 5);
        g.setColor(TangoColors.SCARLET_2);
        HardAndSoftScore score = schedule.getScore();
        if (score != null) {
            String totalDistanceString = !score.isFeasible() ? "Not feasible" : this.numberFormat.format(-score.getSoftScore()) + " fuel";
            g.setFont(g.getFont().deriveFont(1, 24.0f));
            g.drawString(totalDistanceString, (int)width - g.getFontMetrics().stringWidth(totalDistanceString) - 10, (int)height - 10);
        }
        this.repaint();
    }

    public void updatePanel(VrpSchedule schedule) {
        this.resetPanel(schedule);
    }

    private Graphics createCanvas(double width, double height) {
        int canvasWidth = (int)Math.ceil(width) + 1;
        int canvasHeight = (int)Math.ceil(height) + 1;
        this.canvas = new BufferedImage(canvasWidth, canvasHeight, 1);
        Graphics g = this.canvas.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, canvasWidth, canvasHeight);
        return g;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.canvas != null) {
            g.drawImage(this.canvas, 0, 0, this);
        }
    }
}

