/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.common.app;

import java.io.File;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.XmlSolverFactory;
import org.drools.planner.config.termination.TerminationConfig;
import org.drools.planner.core.Solver;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.app.LoggingTest;
import org.drools.planner.examples.common.persistence.SolutionDao;
import org.junit.Assert;
import org.junit.Before;

public abstract class SolverPerformanceTest
extends LoggingTest {
    protected SolutionDao solutionDao;

    @Before
    public void setUp() {
        this.solutionDao = this.createSolutionDao();
        File dataDir = this.solutionDao.getDataDir();
        if (!dataDir.exists()) {
            throw new IllegalStateException("The directory dataDir (" + dataDir.getAbsolutePath() + ") does not exist." + " The working directory should be set to the directory that contains the data directory." + " This is different in a git clone (drools-planner/drools-planner-examples)" + " and the release zip (examples).");
        }
    }

    protected abstract String createSolverConfigResource();

    protected abstract SolutionDao createSolutionDao();

    protected void runSpeedTest(File unsolvedDataFile, String scoreAttainedString) {
        this.runSpeedTest(unsolvedDataFile, scoreAttainedString, EnvironmentMode.REPRODUCIBLE);
    }

    protected void runSpeedTest(File unsolvedDataFile, String scoreAttainedString, EnvironmentMode environmentMode) {
        XmlSolverFactory solverFactory = this.buildSolverFactory(scoreAttainedString, environmentMode);
        Solver solver = this.solve(solverFactory, unsolvedDataFile);
        this.assertBestSolution(solver, scoreAttainedString);
    }

    private XmlSolverFactory buildSolverFactory(String scoreAttainedString, EnvironmentMode environmentMode) {
        XmlSolverFactory solverFactory = new XmlSolverFactory();
        solverFactory.configure(this.createSolverConfigResource());
        solverFactory.getSolverConfig().setEnvironmentMode(environmentMode);
        TerminationConfig terminationConfig = new TerminationConfig();
        terminationConfig.setScoreAttained(scoreAttainedString);
        solverFactory.getSolverConfig().setTerminationConfig(terminationConfig);
        return solverFactory;
    }

    private Solver solve(XmlSolverFactory solverFactory, File unsolvedDataFile) {
        Solution planningProblem = this.solutionDao.readSolution(unsolvedDataFile);
        Solver solver = solverFactory.buildSolver();
        solver.setPlanningProblem(planningProblem);
        solver.solve();
        return solver;
    }

    private void assertBestSolution(Solver solver, String scoreAttainedString) {
        Solution bestSolution = solver.getBestSolution();
        Assert.assertNotNull((Object)bestSolution);
        Score bestScore = bestSolution.getScore();
        Score scoreAttained = solver.getScoreDirectorFactory().getScoreDefinition().parseScore(scoreAttainedString);
        Assert.assertTrue((String)("The bestScore (" + bestScore + ") must be at least scoreAttained (" + scoreAttained + ")."), (bestScore.compareTo((Object)scoreAttained) >= 0 ? 1 : 0) != 0);
    }
}

