/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.curriculumcourse.solver.move;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.examples.curriculumcourse.domain.Lecture;
import org.drools.planner.examples.curriculumcourse.domain.Period;
import org.drools.planner.examples.curriculumcourse.domain.Room;
import org.drools.planner.examples.curriculumcourse.solver.move.CurriculumCourseMoveHelper;

public class LectureSwapMove
implements Move {
    private Lecture leftLecture;
    private Lecture rightLecture;

    public LectureSwapMove(Lecture leftLecture, Lecture rightLecture) {
        this.leftLecture = leftLecture;
        this.rightLecture = rightLecture;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.leftLecture.getPeriod(), (Object)this.rightLecture.getPeriod()) || !ObjectUtils.equals((Object)this.leftLecture.getRoom(), (Object)this.rightLecture.getRoom());
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new LectureSwapMove(this.rightLecture, this.leftLecture);
    }

    public void doMove(ScoreDirector scoreDirector) {
        Period oldLeftPeriod = this.leftLecture.getPeriod();
        Period oldRightPeriod = this.rightLecture.getPeriod();
        Room oldLeftRoom = this.leftLecture.getRoom();
        Room oldRightRoom = this.rightLecture.getRoom();
        if (oldLeftPeriod.equals(oldRightPeriod)) {
            CurriculumCourseMoveHelper.moveRoom(scoreDirector, this.leftLecture, oldRightRoom);
            CurriculumCourseMoveHelper.moveRoom(scoreDirector, this.rightLecture, oldLeftRoom);
        } else if (oldLeftRoom.equals(oldRightRoom)) {
            CurriculumCourseMoveHelper.movePeriod(scoreDirector, this.leftLecture, oldRightPeriod);
            CurriculumCourseMoveHelper.movePeriod(scoreDirector, this.rightLecture, oldLeftPeriod);
        } else {
            CurriculumCourseMoveHelper.moveLecture(scoreDirector, this.leftLecture, oldRightPeriod, oldRightRoom);
            CurriculumCourseMoveHelper.moveLecture(scoreDirector, this.rightLecture, oldLeftPeriod, oldLeftRoom);
        }
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftLecture, this.rightLecture);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Arrays.asList(this.leftLecture.getPeriod(), this.leftLecture.getRoom(), this.rightLecture.getPeriod(), this.rightLecture.getRoom());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LectureSwapMove) {
            LectureSwapMove other = (LectureSwapMove)o;
            return new EqualsBuilder().append((Object)this.leftLecture, (Object)other.leftLecture).append((Object)this.rightLecture, (Object)other.rightLecture).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftLecture).append((Object)this.rightLecture).toHashCode();
    }

    public String toString() {
        return this.leftLecture + " <=> " + this.rightLecture;
    }
}

