/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.entity.PlanningEntity;
import org.drools.planner.api.domain.variable.PlanningVariable;
import org.drools.planner.api.domain.variable.ValueRange;
import org.drools.planner.api.domain.variable.ValueRangeType;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.domain.solver.CloudComputerStrengthComparator;
import org.drools.planner.examples.cloudbalancing.domain.solver.CloudProcessDifficultyComparator;
import org.drools.planner.examples.common.domain.AbstractPersistable;

@PlanningEntity(difficultyComparatorClass=CloudProcessDifficultyComparator.class)
@XStreamAlias(value="CloudProcess")
public class CloudProcess
extends AbstractPersistable {
    private int requiredCpuPower;
    private int requiredMemory;
    private int requiredNetworkBandwidth;
    private CloudComputer computer;

    public int getRequiredCpuPower() {
        return this.requiredCpuPower;
    }

    public void setRequiredCpuPower(int requiredCpuPower) {
        this.requiredCpuPower = requiredCpuPower;
    }

    public int getRequiredMemory() {
        return this.requiredMemory;
    }

    public void setRequiredMemory(int requiredMemory) {
        this.requiredMemory = requiredMemory;
    }

    public int getRequiredNetworkBandwidth() {
        return this.requiredNetworkBandwidth;
    }

    public void setRequiredNetworkBandwidth(int requiredNetworkBandwidth) {
        this.requiredNetworkBandwidth = requiredNetworkBandwidth;
    }

    @PlanningVariable(strengthComparatorClass=CloudComputerStrengthComparator.class)
    @ValueRange(type=ValueRangeType.FROM_SOLUTION_PROPERTY, solutionProperty="computerList")
    public CloudComputer getComputer() {
        return this.computer;
    }

    public void setComputer(CloudComputer computer) {
        this.computer = computer;
    }

    public int getRequiredMultiplicand() {
        return this.requiredCpuPower * this.requiredMemory * this.requiredNetworkBandwidth;
    }

    public String getLabel() {
        return "Process " + this.id;
    }

    public CloudProcess clone() {
        CloudProcess clone = new CloudProcess();
        clone.id = this.id;
        clone.requiredCpuPower = this.requiredCpuPower;
        clone.requiredMemory = this.requiredMemory;
        clone.requiredNetworkBandwidth = this.requiredNetworkBandwidth;
        clone.computer = this.computer;
        return clone;
    }

    public boolean solutionEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CloudProcess) {
            CloudProcess other = (CloudProcess)o;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.computer, (Object)other.computer).isEquals();
        }
        return false;
    }

    public int solutionHashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.computer).toHashCode();
    }

    @Override
    public String toString() {
        return this.getLabel() + "->" + this.computer;
    }
}

