/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.pas.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.entity.PlanningEntity;
import org.drools.planner.api.domain.variable.PlanningVariable;
import org.drools.planner.api.domain.variable.ValueRange;
import org.drools.planner.api.domain.variable.ValueRangeType;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.pas.domain.AdmissionPart;
import org.drools.planner.examples.pas.domain.Bed;
import org.drools.planner.examples.pas.domain.Department;
import org.drools.planner.examples.pas.domain.Gender;
import org.drools.planner.examples.pas.domain.GenderLimitation;
import org.drools.planner.examples.pas.domain.Patient;
import org.drools.planner.examples.pas.domain.Room;
import org.drools.planner.examples.pas.domain.Specialism;
import org.drools.planner.examples.pas.domain.solver.BedDesignationDifficultyWeightFactory;
import org.drools.planner.examples.pas.domain.solver.BedStrengthComparator;

@PlanningEntity(difficultyWeightFactoryClass=BedDesignationDifficultyWeightFactory.class)
@XStreamAlias(value="BedDesignation")
public class BedDesignation
extends AbstractPersistable {
    private AdmissionPart admissionPart;
    private Bed bed;

    public AdmissionPart getAdmissionPart() {
        return this.admissionPart;
    }

    public void setAdmissionPart(AdmissionPart admissionPart) {
        this.admissionPart = admissionPart;
    }

    @PlanningVariable(strengthComparatorClass=BedStrengthComparator.class)
    @ValueRange(type=ValueRangeType.FROM_SOLUTION_PROPERTY, solutionProperty="bedList")
    public Bed getBed() {
        return this.bed;
    }

    public void setBed(Bed bed) {
        this.bed = bed;
    }

    public Patient getPatient() {
        return this.admissionPart.getPatient();
    }

    public Gender getPatientGender() {
        return this.admissionPart.getPatient().getGender();
    }

    public int getPatientAge() {
        return this.admissionPart.getPatient().getAge();
    }

    public Integer getPatientPreferredMaximumRoomCapacity() {
        return this.admissionPart.getPatient().getPreferredMaximumRoomCapacity();
    }

    public Specialism getAdmissionPartSpecialism() {
        return this.admissionPart.getSpecialism();
    }

    public int getAdmissionPartNightCount() {
        return this.admissionPart.getNightCount();
    }

    public Room getRoom() {
        if (this.bed == null) {
            return null;
        }
        return this.bed.getRoom();
    }

    public int getRoomCapacity() {
        if (this.bed == null) {
            return Integer.MIN_VALUE;
        }
        return this.bed.getRoom().getCapacity();
    }

    public Department getDepartment() {
        if (this.bed == null) {
            return null;
        }
        return this.bed.getRoom().getDepartment();
    }

    public GenderLimitation getRoomGenderLimitation() {
        if (this.bed == null) {
            return null;
        }
        return this.bed.getRoom().getGenderLimitation();
    }

    public BedDesignation clone() {
        BedDesignation clone = new BedDesignation();
        clone.id = this.id;
        clone.admissionPart = this.admissionPart;
        clone.bed = this.bed;
        return clone;
    }

    public boolean solutionEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BedDesignation) {
            BedDesignation other = (BedDesignation)o;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.admissionPart, (Object)other.admissionPart).append((Object)this.bed, (Object)other.bed).isEquals();
        }
        return false;
    }

    public int solutionHashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.admissionPart).append((Object)this.bed).toHashCode();
    }

    @Override
    public String toString() {
        return this.admissionPart + " @ " + this.bed;
    }
}

