/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.entity.PlanningEntity;
import org.drools.planner.api.domain.variable.PlanningVariable;
import org.drools.planner.api.domain.variable.ValueRange;
import org.drools.planner.api.domain.variable.ValueRangeType;
import org.drools.planner.api.domain.variable.ValueRanges;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.tsp.domain.Appearance;
import org.drools.planner.examples.tsp.domain.City;

@PlanningEntity
@XStreamAlias(value="Visit")
public class Visit
extends AbstractPersistable
implements Appearance {
    private City city;
    private Appearance previousAppearance;

    @Override
    public City getCity() {
        return this.city;
    }

    public void setCity(City city) {
        this.city = city;
    }

    @PlanningVariable(chained=true)
    @ValueRanges(value={@ValueRange(type=ValueRangeType.FROM_SOLUTION_PROPERTY, solutionProperty="domicileList"), @ValueRange(type=ValueRangeType.FROM_SOLUTION_PROPERTY, solutionProperty="visitList", excludeUninitializedPlanningEntity=true)})
    public Appearance getPreviousAppearance() {
        return this.previousAppearance;
    }

    public void setPreviousAppearance(Appearance previousAppearance) {
        this.previousAppearance = previousAppearance;
    }

    public int getDistanceToPreviousAppearance() {
        if (this.previousAppearance == null) {
            return 0;
        }
        return this.getDistanceTo(this.previousAppearance);
    }

    public int getDistanceTo(Appearance appearance) {
        return this.city.getDistance(appearance.getCity());
    }

    public Visit clone() {
        Visit clone = new Visit();
        clone.id = this.id;
        clone.city = this.city;
        clone.previousAppearance = this.previousAppearance;
        return clone;
    }

    public boolean solutionEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Visit) {
            Visit other = (Visit)o;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.city, (Object)other.city).append((Object)this.previousAppearance, (Object)other.previousAppearance).isEquals();
        }
        return false;
    }

    public int solutionHashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.city).append((Object)this.previousAppearance).toHashCode();
    }

    @Override
    public String toString() {
        return this.city + "(after " + (this.previousAppearance == null ? "null" : this.previousAppearance.getCity()) + ")";
    }
}

