/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import org.eclipse.jetty.osgi.boot.OSGiAppProvider;
import org.eclipse.jetty.osgi.boot.utils.internal.PackageAdminServiceTracker;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.log.Log;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

class AutoStartWhenFrameworkHasCompleted
implements Scanner.ScanCycleListener {
    private final OSGiAppProvider _appProvider;

    AutoStartWhenFrameworkHasCompleted(OSGiAppProvider appProvider) {
        this._appProvider = appProvider;
    }

    public void scanStarted(int cycle) throws Exception {
    }

    public void scanEnded(int cycle) throws Exception {
        if (this._appProvider._pendingBundlesToStart != null && PackageAdminServiceTracker.INSTANCE.frameworkHasCompletedAutostarts()) {
            for (Bundle b : this._appProvider._pendingBundlesToStart) {
                if (b.getHeaders().get("Fragment-Host") != null) continue;
                try {
                    b.start();
                }
                catch (BundleException e) {
                    Log.warn((String)("Unable to start the bundle " + b.getLocation()), (Throwable)e);
                }
            }
            this._appProvider._pendingBundlesToStart = null;
        }
    }
}

