/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.server.session.AbstractTestServer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractClientCrossContextSessionTest {
    public abstract AbstractTestServer createServer(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCrossContextDispatch() throws Exception {
        String contextA = "/contextA";
        String contextB = "/contextB";
        String servletMapping = "/server";
        AbstractTestServer server = this.createServer(0);
        TestServletA servletA = new TestServletA();
        ServletHolder holderA = new ServletHolder((Servlet)servletA);
        ServletContextHandler ctxA = server.addContext(contextA);
        ctxA.addServlet(holderA, servletMapping);
        ServletContextHandler ctxB = server.addContext(contextB);
        TestServletB servletB = new TestServletB();
        ServletHolder holderB = new ServletHolder((Servlet)servletB);
        ctxB.addServlet(holderB, servletMapping);
        server.start();
        int port = server.getPort();
        try {
            HttpClient client = new HttpClient();
            client.setConnectorType(0);
            client.start();
            try {
                ContentExchange exchangeA = new ContentExchange(true);
                exchangeA.setMethod("GET");
                exchangeA.setURL("http://localhost:" + port + contextA + servletMapping);
                client.send((HttpExchange)exchangeA);
                exchangeA.waitForDone();
                Assert.assertEquals((long)200L, (long)exchangeA.getResponseStatus());
                String sessionCookie = exchangeA.getResponseFields().getStringField("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                ContentExchange exchangeB = new ContentExchange(true);
                exchangeB.setMethod("GET");
                exchangeB.setURL("http://localhost:" + port + contextB + servletMapping);
                System.err.println("Cookie = " + sessionCookie);
                exchangeB.getRequestFields().add("Cookie", sessionCookie);
                client.send((HttpExchange)exchangeB);
                exchangeB.waitForDone();
                Assert.assertEquals((long)200L, (long)exchangeB.getResponseStatus());
                Assert.assertEquals((Object)servletA.sessionId, (Object)servletB.sessionId);
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    public static class TestServletB
    extends HttpServlet {
        public String sessionId;

        protected void doGet(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            HttpSession session = request.getSession(false);
            if (session == null) {
                session = request.getSession(true);
            }
            this.sessionId = session.getId();
            session.setAttribute("B", (Object)"B");
            Object objectA = session.getAttribute("A");
            Assert.assertTrue((objectA == null ? 1 : 0) != 0);
        }
    }

    public static class TestServletA
    extends HttpServlet {
        public String sessionId;

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            HttpSession session = request.getSession(false);
            if (session == null) {
                session = request.getSession(true);
                this.sessionId = session.getId();
            }
            session.setAttribute("A", (Object)"A");
            Object objectB = session.getAttribute("B");
            Assert.assertTrue((objectB == null ? 1 : 0) != 0);
        }
    }
}

