/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.server.session.AbstractTestServer;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractImmortalSessionTest {
    public abstract AbstractTestServer createServer(int var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImmortalSession() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int scavengePeriod = 2;
        AbstractTestServer server = this.createServer(0, -1, scavengePeriod);
        server.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
        server.start();
        int port = server.getPort();
        try {
            HttpClient client = new HttpClient();
            client.setConnectorType(0);
            client.start();
            try {
                int value = 42;
                ContentExchange exchange = new ContentExchange(true);
                exchange.setMethod("GET");
                exchange.setURL("http://localhost:" + port + contextPath + servletMapping + "?action=set&value=" + value);
                client.send((HttpExchange)exchange);
                exchange.waitForDone();
                Assert.assertEquals((long)200L, (long)exchange.getResponseStatus());
                String sessionCookie = exchange.getResponseFields().getStringField("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                String response = exchange.getResponseContent();
                Assert.assertEquals((Object)response.trim(), (Object)String.valueOf(value));
                Thread.sleep((long)scavengePeriod * 2500L);
                exchange = new ContentExchange(true);
                exchange.setMethod("GET");
                exchange.setURL("http://localhost:" + port + contextPath + servletMapping + "?action=get");
                exchange.getRequestFields().add("Cookie", sessionCookie);
                client.send((HttpExchange)exchange);
                exchange.waitForDone();
                Assert.assertEquals((long)200L, (long)exchange.getResponseStatus());
                response = exchange.getResponseContent();
                Assert.assertEquals((Object)String.valueOf(value), (Object)response.trim());
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            HttpSession session;
            String result = null;
            String action = request.getParameter("action");
            if ("set".equals(action)) {
                String value = request.getParameter("value");
                HttpSession session2 = request.getSession(true);
                session2.setAttribute("value", (Object)value);
                result = value;
            } else if ("get".equals(action) && (session = request.getSession(false)) != null) {
                result = (String)session.getAttribute("value");
            }
            PrintWriter writer = response.getWriter();
            writer.println(result);
            writer.flush();
        }
    }
}

