/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.server.session.AbstractTestServer;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractInvalidationSessionTest {
    public abstract AbstractTestServer createServer(int var1);

    public abstract void pause();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidation() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        AbstractTestServer server1 = this.createServer(0);
        server1.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
        server1.start();
        int port1 = server1.getPort();
        try {
            AbstractTestServer server2 = this.createServer(0);
            server2.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
            server2.start();
            int port2 = server2.getPort();
            try {
                HttpClient client = new HttpClient();
                client.setConnectorType(0);
                client.start();
                try {
                    String[] urls = new String[]{"http://localhost:" + port1 + contextPath + servletMapping, "http://localhost:" + port2 + contextPath + servletMapping};
                    ContentExchange exchange1 = new ContentExchange(true);
                    exchange1.setMethod("GET");
                    exchange1.setURL(urls[0] + "?action=init");
                    client.send((HttpExchange)exchange1);
                    exchange1.waitForDone();
                    Assert.assertEquals((long)200L, (long)exchange1.getResponseStatus());
                    String sessionCookie = exchange1.getResponseFields().getStringField("Set-Cookie");
                    Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                    sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                    ContentExchange exchange2 = new ContentExchange(true);
                    exchange2.setMethod("GET");
                    exchange2.setURL(urls[1] + "?action=increment");
                    exchange2.getRequestFields().add("Cookie", sessionCookie);
                    client.send((HttpExchange)exchange2);
                    exchange2.waitForDone();
                    Assert.assertEquals((long)200L, (long)exchange2.getResponseStatus());
                    exchange1 = new ContentExchange(true);
                    exchange1.setMethod("GET");
                    exchange1.setURL(urls[0] + "?action=invalidate");
                    exchange1.getRequestFields().add("Cookie", sessionCookie);
                    client.send((HttpExchange)exchange1);
                    exchange1.waitForDone();
                    Assert.assertEquals((long)200L, (long)exchange1.getResponseStatus());
                    this.pause();
                    exchange2 = new ContentExchange(true);
                    exchange2.setMethod("GET");
                    exchange2.setURL(urls[1] + "?action=test");
                    exchange2.getRequestFields().add("Cookie", sessionCookie);
                    client.send((HttpExchange)exchange2);
                    exchange2.waitForDone();
                    Assert.assertEquals((long)200L, (long)exchange2.getResponseStatus());
                }
                finally {
                    client.stop();
                }
            }
            finally {
                server2.stop();
            }
        }
        finally {
            server1.stop();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("init".equals(action)) {
                HttpSession session = request.getSession(true);
                session.setAttribute("value", (Object)0);
            } else if ("increment".equals(action)) {
                HttpSession session = request.getSession(false);
                int value = (Integer)session.getAttribute("value");
                session.setAttribute("value", (Object)(value + 1));
            } else if ("invalidate".equals(action)) {
                HttpSession session = request.getSession(false);
                session.invalidate();
            } else if ("test".equals(action)) {
                HttpSession session = request.getSession(false);
                Assert.assertEquals(null, (Object)session);
            }
        }
    }
}

