/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.EventListener;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.server.session.AbstractTestServer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractLastAccessTimeTest {
    public abstract AbstractTestServer createServer(int var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastAccessTime() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int maxInactivePeriod = 8;
        int scavengePeriod = 2;
        AbstractTestServer server1 = this.createServer(0, maxInactivePeriod, scavengePeriod);
        TestServlet servlet1 = new TestServlet();
        ServletHolder holder1 = new ServletHolder((Servlet)servlet1);
        ServletContextHandler context = server1.addContext(contextPath);
        TestSessionListener listener1 = new TestSessionListener();
        context.addEventListener((EventListener)((Object)listener1));
        context.addServlet(holder1, servletMapping);
        server1.start();
        int port1 = server1.getPort();
        try {
            AbstractTestServer server2 = this.createServer(0, maxInactivePeriod, scavengePeriod);
            server2.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
            server2.start();
            int port2 = server2.getPort();
            try {
                HttpClient client = new HttpClient();
                client.setConnectorType(0);
                client.start();
                try {
                    ContentExchange exchange1 = new ContentExchange(true);
                    exchange1.setMethod("GET");
                    exchange1.setURL("http://localhost:" + port1 + contextPath + servletMapping + "?action=init");
                    client.send((HttpExchange)exchange1);
                    exchange1.waitForDone();
                    Assert.assertEquals((long)200L, (long)exchange1.getResponseStatus());
                    Assert.assertEquals((Object)"test", (Object)exchange1.getResponseContent());
                    String sessionCookie = exchange1.getResponseFields().getStringField("Set-Cookie");
                    Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                    sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                    int requestInterval = 500;
                    for (int i = 0; i < maxInactivePeriod * (1000 / requestInterval); ++i) {
                        ContentExchange exchange2 = new ContentExchange(true);
                        exchange2.setMethod("GET");
                        exchange2.setURL("http://localhost:" + port2 + contextPath + servletMapping);
                        exchange2.getRequestFields().add("Cookie", sessionCookie);
                        client.send((HttpExchange)exchange2);
                        exchange2.waitForDone();
                        Assert.assertEquals((long)200L, (long)exchange2.getResponseStatus());
                        Assert.assertEquals((Object)"test", (Object)exchange2.getResponseContent());
                        String setCookie = exchange1.getResponseFields().getStringField("Set-Cookie");
                        if (setCookie != null) {
                            sessionCookie = setCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                        }
                        Thread.sleep(requestInterval);
                    }
                    Thread.sleep((long)scavengePeriod * 2500L);
                    Assert.assertTrue((!listener1.destroyed ? 1 : 0) != 0);
                }
                finally {
                    client.stop();
                }
            }
            finally {
                server2.stop();
            }
        }
        finally {
            server1.stop();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("init".equals(action)) {
                HttpSession session = request.getSession(true);
                session.setAttribute("test", (Object)"test");
                this.sendResult(session, httpServletResponse.getWriter());
            } else {
                HttpSession session = request.getSession(false);
                this.sendResult(session, httpServletResponse.getWriter());
                if (session != null) {
                    session.setAttribute("test", (Object)"test");
                }
            }
        }

        private void sendResult(HttpSession session, PrintWriter writer) {
            if (session != null) {
                writer.print(session.getAttribute("test"));
            } else {
                writer.print("null");
            }
        }
    }

    public static class TestSessionListener
    implements HttpSessionListener {
        public boolean destroyed = false;
        public boolean created = false;

        public void sessionDestroyed(HttpSessionEvent se) {
            this.destroyed = true;
        }

        public void sessionCreated(HttpSessionEvent se) {
            this.created = true;
        }
    }
}

