/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.server.session.AbstractTestServer;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractLightLoadTest {
    protected boolean _stress = Boolean.getBoolean("STRESS");

    public abstract AbstractTestServer createServer(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLightLoad() throws Exception {
        if (this._stress) {
            String contextPath = "";
            String servletMapping = "/server";
            AbstractTestServer server1 = this.createServer(0);
            server1.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
            server1.start();
            int port1 = server1.getPort();
            try {
                AbstractTestServer server2 = this.createServer(0);
                server2.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
                server2.start();
                int port2 = server2.getPort();
                try {
                    HttpClient client = new HttpClient();
                    client.setConnectorType(0);
                    client.start();
                    try {
                        String[] urls = new String[]{"http://localhost:" + port1 + contextPath + servletMapping, "http://localhost:" + port2 + contextPath + servletMapping};
                        ContentExchange exchange1 = new ContentExchange(true);
                        exchange1.setMethod("GET");
                        exchange1.setURL(urls[0] + "?action=init");
                        client.send((HttpExchange)exchange1);
                        exchange1.waitForDone();
                        Assert.assertEquals((long)200L, (long)exchange1.getResponseStatus());
                        String sessionCookie = exchange1.getResponseFields().getStringField("Set-Cookie");
                        Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                        sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                        ExecutorService executor = Executors.newCachedThreadPool();
                        int clientsCount = 50;
                        CyclicBarrier barrier = new CyclicBarrier(clientsCount + 1);
                        int requestsCount = 100;
                        Worker[] workers = new Worker[clientsCount];
                        for (int i = 0; i < clientsCount; ++i) {
                            workers[i] = new Worker(barrier, requestsCount, sessionCookie, urls);
                            workers[i].start();
                            executor.execute(workers[i]);
                        }
                        barrier.await();
                        long start = System.nanoTime();
                        barrier.await();
                        long end = System.nanoTime();
                        long elapsed = TimeUnit.NANOSECONDS.toMillis(end - start);
                        System.out.println("elapsed ms: " + elapsed);
                        for (Worker worker : workers) {
                            worker.stop();
                        }
                        executor.shutdownNow();
                        ContentExchange exchange2 = new ContentExchange(true);
                        exchange2.setMethod("GET");
                        exchange2.setURL(urls[0] + "?action=result");
                        exchange2.getRequestFields().add("Cookie", sessionCookie);
                        client.send((HttpExchange)exchange2);
                        exchange2.waitForDone();
                        Assert.assertEquals((long)200L, (long)exchange2.getResponseStatus());
                        String response = exchange2.getResponseContent();
                        System.out.println("get = " + response);
                        Assert.assertEquals((Object)response.trim(), (Object)String.valueOf(clientsCount * requestsCount));
                    }
                    finally {
                        client.stop();
                    }
                }
                finally {
                    server2.stop();
                }
            }
            finally {
                server1.stop();
            }
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("init".equals(action)) {
                HttpSession session = request.getSession(true);
                session.setAttribute("value", (Object)0);
            } else if ("increment".equals(action)) {
                HttpSession session = request.getSession(false);
                int value = (Integer)session.getAttribute("value");
                session.setAttribute("value", (Object)(value + 1));
            } else if ("result".equals(action)) {
                HttpSession session = request.getSession(false);
                int value = (Integer)session.getAttribute("value");
                PrintWriter writer = response.getWriter();
                writer.println(value);
                writer.flush();
            }
        }
    }

    public static class Worker
    implements Runnable {
        private final HttpClient client = new HttpClient();
        private final CyclicBarrier barrier;
        private final int requestsCount;
        private final String sessionCookie;
        private final String[] urls;

        public Worker(CyclicBarrier barrier, int requestsCount, String sessionCookie, String[] urls) {
            this.client.setConnectorType(0);
            this.barrier = barrier;
            this.requestsCount = requestsCount;
            this.sessionCookie = sessionCookie;
            this.urls = urls;
        }

        public void start() throws Exception {
            this.client.start();
        }

        public void stop() throws Exception {
            this.client.stop();
        }

        @Override
        public void run() {
            try {
                this.barrier.await();
                Random random = new Random(System.nanoTime());
                for (int i = 0; i < this.requestsCount; ++i) {
                    int urlIndex = random.nextInt(this.urls.length);
                    ContentExchange exchange = new ContentExchange(true);
                    exchange.setMethod("GET");
                    exchange.setURL(this.urls[urlIndex] + "?action=increment");
                    exchange.getRequestFields().add("Cookie", this.sessionCookie);
                    this.client.send((HttpExchange)exchange);
                    exchange.waitForDone();
                    Assert.assertEquals((long)200L, (long)exchange.getResponseStatus());
                }
                this.barrier.await();
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
    }
}

