/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.session.AbstractTestServer;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractLocalSessionScavengingTest {
    public abstract AbstractTestServer createServer(int var1, int var2, int var3);

    public void pause(int scavengePeriod) {
        try {
            Thread.sleep((long)scavengePeriod * 2500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalSessionsScavenging() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int inactivePeriod = 1;
        int scavengePeriod = 2;
        AbstractTestServer server1 = this.createServer(0, inactivePeriod, scavengePeriod);
        server1.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
        server1.start();
        int port1 = server1.getPort();
        try {
            AbstractTestServer server2 = this.createServer(0, inactivePeriod, scavengePeriod * 3);
            server2.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
            server2.start();
            int port2 = server2.getPort();
            try {
                HttpClient client = new HttpClient();
                client.setConnectorType(0);
                client.start();
                try {
                    String[] urls = new String[]{"http://localhost:" + port1 + contextPath + servletMapping, "http://localhost:" + port2 + contextPath + servletMapping};
                    ContentExchange exchange1 = new ContentExchange(true);
                    exchange1.setMethod("GET");
                    exchange1.setURL(urls[0] + "?action=init");
                    client.send((HttpExchange)exchange1);
                    exchange1.waitForDone();
                    Assert.assertEquals((long)200L, (long)exchange1.getResponseStatus());
                    String sessionCookie = exchange1.getResponseFields().getStringField("Set-Cookie");
                    Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                    sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                    ContentExchange exchange2 = new ContentExchange(true);
                    exchange2.setMethod("GET");
                    exchange2.setURL(urls[1] + "?action=test");
                    exchange2.getRequestFields().add("Cookie", sessionCookie);
                    client.send((HttpExchange)exchange2);
                    exchange2.waitForDone();
                    Assert.assertEquals((long)200L, (long)exchange2.getResponseStatus());
                    this.pause(scavengePeriod);
                    exchange1 = new ContentExchange(true);
                    exchange1.setMethod("GET");
                    exchange1.setURL(urls[0] + "?action=check");
                    client.send((HttpExchange)exchange1);
                    exchange1.waitForDone();
                    Assert.assertEquals((long)200L, (long)exchange1.getResponseStatus());
                    this.pause(scavengePeriod);
                    exchange2 = new ContentExchange(true);
                    exchange2.setMethod("GET");
                    exchange2.setURL(urls[1] + "?action=check");
                    client.send((HttpExchange)exchange2);
                    exchange2.waitForDone();
                    Assert.assertEquals((long)200L, (long)exchange2.getResponseStatus());
                }
                finally {
                    client.stop();
                }
            }
            finally {
                server2.stop();
            }
        }
        finally {
            server1.stop();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        private SessionManager sessionManager;

        protected void doGet(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("init".equals(action)) {
                HttpSession session = request.getSession(true);
                session.setAttribute("test", (Object)"test");
                this.sessionManager = ((Request)request).getSessionManager();
            } else if ("test".equals(action)) {
                HttpSession session = request.getSession(false);
                session.setAttribute("test", (Object)"test");
                this.sessionManager = ((Request)request).getSessionManager();
            } else if ("check".equals(action)) {
                HttpSession session = request.getSession(false);
                Assert.assertTrue((session == null ? 1 : 0) != 0);
            }
        }
    }
}

