/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.server.session.AbstractTestServer;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractOrphanedSessionTest {
    public abstract AbstractTestServer createServer(int var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrphanedSession() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int inactivePeriod = 5;
        AbstractTestServer server1 = this.createServer(0, inactivePeriod, -1);
        server1.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
        server1.start();
        int port1 = server1.getPort();
        try {
            int scavengePeriod = 2;
            AbstractTestServer server2 = this.createServer(0, inactivePeriod, scavengePeriod);
            server2.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
            server2.start();
            int port2 = server2.getPort();
            try {
                HttpClient client = new HttpClient();
                client.setConnectorType(0);
                client.start();
                try {
                    ContentExchange exchange1 = new ContentExchange(true);
                    exchange1.setMethod("GET");
                    exchange1.setURL("http://localhost:" + port1 + contextPath + servletMapping + "?action=init");
                    client.send((HttpExchange)exchange1);
                    exchange1.waitForDone();
                    Assert.assertEquals((long)200L, (long)exchange1.getResponseStatus());
                    String sessionCookie = exchange1.getResponseFields().getStringField("Set-Cookie");
                    Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                    sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                    Thread.sleep(TimeUnit.SECONDS.toMillis((long)inactivePeriod + 2L * (long)scavengePeriod));
                    ContentExchange exchange2 = new ContentExchange(true);
                    exchange2.setMethod("GET");
                    exchange2.setURL("http://localhost:" + port2 + contextPath + servletMapping + "?action=check");
                    exchange2.getRequestFields().add("Cookie", sessionCookie);
                    client.send((HttpExchange)exchange2);
                    exchange2.waitForDone();
                    Assert.assertEquals((long)200L, (long)exchange2.getResponseStatus());
                }
                finally {
                    client.stop();
                }
            }
            finally {
                server2.stop();
            }
        }
        finally {
            server1.stop();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("init".equals(action)) {
                HttpSession session = request.getSession(true);
                session.setAttribute("A", (Object)"A");
            } else if ("remove".equals(action)) {
                HttpSession session = request.getSession(false);
                session.invalidate();
            } else if ("check".equals(action)) {
                HttpSession session = request.getSession(false);
                Assert.assertTrue((session == null ? 1 : 0) != 0);
            }
        }
    }
}

