/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.server.session.AbstractTestServer;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractReentrantRequestSessionTest {
    public abstract AbstractTestServer createServer(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReentrantRequestSession() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        AbstractTestServer server = this.createServer(0);
        server.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
        server.start();
        int port = server.getPort();
        try {
            HttpClient client = new HttpClient();
            client.setConnectorType(0);
            client.start();
            try {
                ContentExchange exchange = new ContentExchange(true);
                exchange.setMethod("GET");
                exchange.setURL("http://localhost:" + port + contextPath + servletMapping + "?action=reenter&port=" + port + "&path=" + contextPath + servletMapping);
                client.send((HttpExchange)exchange);
                exchange.waitForDone();
                Assert.assertEquals((long)200L, (long)exchange.getResponseStatus());
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.doPost(request, response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            block7: {
                HttpSession session = request.getSession(false);
                String action = request.getParameter("action");
                if ("reenter".equals(action)) {
                    if (session == null) {
                        session = request.getSession(true);
                    }
                    int port = Integer.parseInt(request.getParameter("port"));
                    String path = request.getParameter("path");
                    try {
                        HttpClient client = new HttpClient();
                        client.setConnectorType(0);
                        client.start();
                        try {
                            ContentExchange exchange = new ContentExchange(true);
                            exchange.setMethod("GET");
                            exchange.setURL("http://localhost:" + port + path + ";jsessionid=" + session.getId() + "?action=none");
                            client.send((HttpExchange)exchange);
                            exchange.waitForDone();
                            Assert.assertEquals((long)200L, (long)exchange.getResponseStatus());
                            Assert.assertEquals((Object)"true", (Object)session.getAttribute("reentrant"));
                            break block7;
                        }
                        finally {
                            client.stop();
                        }
                    }
                    catch (Exception x) {
                        throw new ServletException((Throwable)x);
                    }
                }
                Assert.assertTrue((session != null ? 1 : 0) != 0);
                session.setAttribute("reentrant", (Object)"true");
            }
        }
    }
}

