/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.util.EventListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.server.session.AbstractTestServer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractRemoveSessionTest {
    public abstract AbstractTestServer createServer(int var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveSession() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int scavengePeriod = 3;
        AbstractTestServer server = this.createServer(0, 1, scavengePeriod);
        ServletContextHandler context = server.addContext(contextPath);
        context.addServlet(TestServlet.class, servletMapping);
        TestEventListener testListener = new TestEventListener();
        context.getSessionHandler().addEventListener((EventListener)((Object)testListener));
        server.start();
        int port = server.getPort();
        try {
            HttpClient client = new HttpClient();
            client.setConnectorType(0);
            client.start();
            try {
                ContentExchange exchange = new ContentExchange(true);
                exchange.setMethod("GET");
                exchange.setURL("http://localhost:" + port + contextPath + servletMapping + "?action=create");
                client.send((HttpExchange)exchange);
                exchange.waitForDone();
                Assert.assertEquals((long)200L, (long)exchange.getResponseStatus());
                String sessionCookie = exchange.getResponseFields().getStringField("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                Assert.assertTrue((boolean)testListener.isCreated());
                exchange = new ContentExchange(true);
                exchange.setMethod("GET");
                exchange.setURL("http://localhost:" + port + contextPath + servletMapping + "?action=delete");
                exchange.getRequestFields().add("Cookie", sessionCookie);
                client.send((HttpExchange)exchange);
                exchange.waitForDone();
                Assert.assertEquals((long)200L, (long)exchange.getResponseStatus());
                Assert.assertTrue((boolean)testListener.isDestroyed());
                exchange = new ContentExchange(true);
                exchange.setMethod("GET");
                exchange.setURL("http://localhost:" + port + contextPath + servletMapping + "?action=check");
                exchange.getRequestFields().add("Cookie", sessionCookie);
                client.send((HttpExchange)exchange);
                exchange.waitForDone();
                Assert.assertEquals((long)200L, (long)exchange.getResponseStatus());
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    public static class TestEventListener
    implements HttpSessionListener {
        boolean wasCreated;
        boolean wasDestroyed;

        public void sessionCreated(HttpSessionEvent se) {
            this.wasCreated = true;
        }

        public void sessionDestroyed(HttpSessionEvent se) {
            this.wasDestroyed = true;
        }

        public boolean isDestroyed() {
            return this.wasDestroyed;
        }

        public boolean isCreated() {
            return this.wasCreated;
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("create".equals(action)) {
                request.getSession(true);
            } else if ("delete".equals(action)) {
                HttpSession s = request.getSession(false);
                Assert.assertNotNull((Object)s);
                s.invalidate();
                s = request.getSession(false);
                Assert.assertNull((Object)s);
            } else {
                HttpSession s = request.getSession(false);
                Assert.assertNull((Object)s);
            }
        }
    }
}

