/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.server.session.AbstractTestServer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractServerCrossContextSessionTest {
    public abstract AbstractTestServer createServer(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCrossContextDispatch() throws Exception {
        String contextA = "/contextA";
        String contextB = "/contextB";
        String servletMapping = "/server";
        AbstractTestServer server = this.createServer(0);
        ServletContextHandler ctxA = server.addContext(contextA);
        ctxA.addServlet(TestServletA.class, servletMapping);
        ServletContextHandler ctxB = server.addContext(contextB);
        ctxB.addServlet(TestServletB.class, servletMapping);
        server.start();
        int port = server.getPort();
        try {
            HttpClient client = new HttpClient();
            client.setConnectorType(0);
            client.start();
            try {
                ContentExchange exchange = new ContentExchange(true);
                exchange.setMethod("GET");
                exchange.setURL("http://localhost:" + port + contextA + servletMapping);
                client.send((HttpExchange)exchange);
                exchange.waitForDone();
                Assert.assertEquals((long)200L, (long)exchange.getResponseStatus());
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    public static class TestServletB
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            Object objectA;
            HttpSession session = request.getSession(false);
            if (session == null) {
                session = request.getSession(true);
            }
            Assert.assertTrue(((objectA = session.getAttribute("A")) == null ? 1 : 0) != 0);
            session.setAttribute("B", (Object)"B");
            System.out.println("B: session.getAttributeNames() = " + Collections.list(session.getAttributeNames()));
        }
    }

    public static class TestServletA
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            HttpSession session = request.getSession(false);
            if (session == null) {
                session = request.getSession(true);
            }
            session.setAttribute("A", (Object)"A");
            System.out.println("A: session.getAttributeNames() = " + Collections.list(session.getAttributeNames()));
            ServletContext contextB = this.getServletContext().getContext("/contextB");
            RequestDispatcher dispatcherB = contextB.getRequestDispatcher(request.getServletPath());
            dispatcherB.forward((ServletRequest)request, (ServletResponse)response);
            Object objectB = session.getAttribute("B");
            Assert.assertTrue((objectB == null ? 1 : 0) != 0);
            System.out.println("A: session.getAttributeNames() = " + Collections.list(session.getAttributeNames()));
        }
    }
}

