/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.session.AbstractTestServer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public abstract class AbstractSessionCookieTest {
    public abstract AbstractTestServer createServer(int var1, int var2, int var3);

    public void pause(int scavenge) {
        try {
            Thread.sleep((long)scavenge * 2500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="failing because an http cookie with null value is coming over as \"null\"")
    public void testSessionCookie() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int scavengePeriod = 3;
        AbstractTestServer server = this.createServer(0, 1, scavengePeriod);
        ServletContextHandler context = server.addContext(contextPath);
        context.addServlet(TestServlet.class, servletMapping);
        server.start();
        int port = server.getPort();
        try {
            HttpClient client = new HttpClient();
            client.setConnectorType(0);
            client.start();
            try {
                ContentExchange exchange = new ContentExchange(true);
                exchange.setMethod("GET");
                exchange.setURL("http://localhost:" + port + contextPath + servletMapping + "?action=create");
                client.send((HttpExchange)exchange);
                exchange.waitForDone();
                Assert.assertEquals((long)200L, (long)exchange.getResponseStatus());
                String sessionCookie = exchange.getResponseFields().getStringField("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                exchange = new ContentExchange(true);
                exchange.setMethod("GET");
                exchange.setURL("http://localhost:" + port + contextPath + servletMapping + "?action=check-cookie");
                exchange.getRequestFields().add("Cookie", sessionCookie);
                client.send((HttpExchange)exchange);
                exchange.waitForDone();
                Assert.assertEquals((long)200L, (long)exchange.getResponseStatus());
                exchange = new ContentExchange(true);
                exchange.setMethod("GET");
                exchange.setURL("http://localhost:" + port + contextPath + servletMapping + "?action=null-cookie");
                HttpDestination dest = client.getDestination(new Address("localhost", port), false);
                dest.addCookie(new HttpCookie("Cookie", null));
                client.send((HttpExchange)exchange);
                exchange.waitForDone();
                Assert.assertEquals((long)200L, (long)exchange.getResponseStatus());
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("create".equals(action)) {
                HttpSession session = request.getSession(true);
                Assert.assertTrue((boolean)session.isNew());
            } else if ("check-cookie".equals(action)) {
                HttpSession session = request.getSession(false);
                Assert.assertTrue((session != null ? 1 : 0) != 0);
            } else if ("null-cookie".equals(action)) {
                HttpSession session = request.getSession(false);
                Assert.assertEquals((long)1L, (long)request.getCookies().length);
                junit.framework.Assert.assertFalse((boolean)"null".equals(request.getCookies()[0].getValue()));
                Assert.assertTrue((session == null ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((boolean)false);
            }
        }
    }
}

