/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.server.session.AbstractTestServer;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractSessionExpiryTest {
    public abstract AbstractTestServer createServer(int var1, int var2, int var3);

    public void pause(int scavengePeriod) {
        try {
            Thread.sleep((long)scavengePeriod * 2500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionNotExpired() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int inactivePeriod = 10;
        int scavengePeriod = 10;
        AbstractTestServer server1 = this.createServer(0, inactivePeriod, scavengePeriod);
        TestServlet servlet = new TestServlet();
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        server1.addContext(contextPath).addServlet(holder, servletMapping);
        server1.start();
        int port1 = server1.getPort();
        try {
            HttpClient client = new HttpClient();
            client.setConnectorType(0);
            client.start();
            String url = "http://localhost:" + port1 + contextPath + servletMapping;
            ContentExchange exchange1 = new ContentExchange(true);
            exchange1.setMethod("GET");
            exchange1.setURL(url + "?action=init");
            client.send((HttpExchange)exchange1);
            exchange1.waitForDone();
            Assert.assertEquals((long)200L, (long)exchange1.getResponseStatus());
            String sessionCookie = exchange1.getResponseFields().getStringField("Set-Cookie");
            Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
            sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
            server1.stop();
            server1.start();
            port1 = server1.getPort();
            url = "http://localhost:" + port1 + contextPath + servletMapping;
            ContentExchange exchange2 = new ContentExchange(true);
            exchange2.setMethod("GET");
            exchange2.setURL(url + "?action=notexpired");
            exchange2.getRequestFields().add("Cookie", sessionCookie);
            client.send((HttpExchange)exchange2);
            exchange2.waitForDone();
            Assert.assertEquals((long)200L, (long)exchange2.getResponseStatus());
        }
        finally {
            server1.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionExpiry() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int inactivePeriod = 2;
        int scavengePeriod = 10;
        AbstractTestServer server1 = this.createServer(0, inactivePeriod, scavengePeriod);
        TestServlet servlet = new TestServlet();
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        server1.addContext(contextPath).addServlet(holder, servletMapping);
        server1.start();
        int port1 = server1.getPort();
        try {
            HttpClient client = new HttpClient();
            client.setConnectorType(0);
            client.start();
            String url = "http://localhost:" + port1 + contextPath + servletMapping;
            ContentExchange exchange1 = new ContentExchange(true);
            exchange1.setMethod("GET");
            exchange1.setURL(url + "?action=init");
            client.send((HttpExchange)exchange1);
            exchange1.waitForDone();
            Assert.assertEquals((long)200L, (long)exchange1.getResponseStatus());
            String sessionCookie = exchange1.getResponseFields().getStringField("Set-Cookie");
            Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
            sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
            server1.stop();
            this.pause(inactivePeriod);
            server1.start();
            port1 = server1.getPort();
            url = "http://localhost:" + port1 + contextPath + servletMapping;
            ContentExchange exchange2 = new ContentExchange(true);
            exchange2.setMethod("GET");
            exchange2.setURL(url + "?action=test");
            exchange2.getRequestFields().add("Cookie", sessionCookie);
            client.send((HttpExchange)exchange2);
            exchange2.waitForDone();
            Assert.assertEquals((long)200L, (long)exchange2.getResponseStatus());
        }
        finally {
            server1.stop();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        public String originalId = null;
        public String testId = null;
        public String checkId = null;

        protected void doGet(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("init".equals(action)) {
                HttpSession session = request.getSession(true);
                session.setAttribute("test", (Object)"test");
                this.originalId = session.getId();
            } else if ("test".equals(action)) {
                HttpSession session = request.getSession(true);
                Assert.assertTrue((session != null ? 1 : 0) != 0);
                Assert.assertTrue((!this.originalId.equals(session.getId()) ? 1 : 0) != 0);
            } else if ("notexpired".equals(action)) {
                HttpSession session = request.getSession(false);
                Assert.assertTrue((session != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)this.originalId.equals(session.getId()));
            }
        }
    }
}

