/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.server.session.AbstractTestServer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractSessionInvalidateAndCreateTest {
    public abstract AbstractTestServer createServer(int var1, int var2, int var3);

    public void pause(int scavengePeriod) {
        try {
            Thread.sleep((long)scavengePeriod * 2500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionScavenge() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int inactivePeriod = 1;
        int scavengePeriod = 2;
        AbstractTestServer server = this.createServer(0, inactivePeriod, scavengePeriod);
        ServletContextHandler context = server.addContext(contextPath);
        TestServlet servlet = new TestServlet();
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        context.addServlet(holder, servletMapping);
        MySessionListener listener = new MySessionListener();
        context.getSessionHandler().addEventListener((EventListener)((Object)listener));
        server.start();
        int port1 = server.getPort();
        try {
            HttpClient client = new HttpClient();
            client.setConnectorType(0);
            client.start();
            try {
                String url = "http://localhost:" + port1 + contextPath + servletMapping;
                ContentExchange exchange1 = new ContentExchange(true);
                exchange1.setMethod("GET");
                exchange1.setURL(url + "?action=init");
                client.send((HttpExchange)exchange1);
                exchange1.waitForDone();
                Assert.assertEquals((long)200L, (long)exchange1.getResponseStatus());
                String sessionCookie = exchange1.getResponseFields().getStringField("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                ContentExchange exchange2 = new ContentExchange(true);
                exchange2.setMethod("GET");
                exchange2.setURL(url + "?action=test");
                exchange2.getRequestFields().add("Cookie", sessionCookie);
                client.send((HttpExchange)exchange2);
                exchange2.waitForDone();
                Assert.assertEquals((long)200L, (long)exchange2.getResponseStatus());
                this.pause(scavengePeriod);
                Assert.assertTrue((boolean)listener.destroys.contains("session1"));
                Assert.assertTrue((boolean)listener.destroys.contains("session2"));
                Assert.assertTrue((boolean)servlet.unbound);
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        private boolean unbound = false;

        protected void doGet(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            HttpSession session;
            String action = request.getParameter("action");
            if ("init".equals(action)) {
                HttpSession session2 = request.getSession(true);
                session2.setAttribute("identity", (Object)"session1");
            } else if ("test".equals(action) && (session = request.getSession(false)) != null) {
                session.invalidate();
                session = request.getSession(true);
                session.setAttribute("identity", (Object)"session2");
                session.setAttribute("listener", (Object)new HttpSessionBindingListener(){

                    public void valueUnbound(HttpSessionBindingEvent event) {
                        TestServlet.this.unbound = true;
                    }

                    public void valueBound(HttpSessionBindingEvent event) {
                    }
                });
            }
        }
    }

    public class MySessionListener
    implements HttpSessionListener {
        List<String> destroys;

        public void sessionCreated(HttpSessionEvent e) {
        }

        public void sessionDestroyed(HttpSessionEvent e) {
            if (this.destroys == null) {
                this.destroys = new ArrayList<String>();
            }
            this.destroys.add((String)e.getSession().getAttribute("identity"));
        }
    }
}

