/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.server.session.AbstractTestServer;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractSessionValueSavingTest {
    public abstract AbstractTestServer createServer(int var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionValueSaving() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int maxInactivePeriod = 10000;
        int scavengePeriod = 20000;
        AbstractTestServer server1 = this.createServer(0, maxInactivePeriod, scavengePeriod);
        server1.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
        server1.start();
        int port1 = server1.getPort();
        try {
            HttpClient client = new HttpClient();
            client.setConnectorType(0);
            client.start();
            try {
                long sessionTestValue = 0L;
                ContentExchange exchange1 = new ContentExchange(true);
                exchange1.setMethod("GET");
                exchange1.setURL("http://localhost:" + port1 + contextPath + servletMapping + "?action=init");
                client.send((HttpExchange)exchange1);
                exchange1.waitForDone();
                Assert.assertEquals((long)200L, (long)exchange1.getResponseStatus());
                System.out.println("Checking: " + sessionTestValue + " vs " + exchange1.getResponseContent());
                Assert.assertTrue((sessionTestValue < Long.parseLong(exchange1.getResponseContent()) ? 1 : 0) != 0);
                sessionTestValue = Long.parseLong(exchange1.getResponseContent());
                String sessionCookie = exchange1.getResponseFields().getStringField("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                int requestInterval = 500;
                for (int i = 0; i < 10; ++i) {
                    ContentExchange exchange2 = new ContentExchange(true);
                    exchange2.setMethod("GET");
                    exchange2.setURL("http://localhost:" + port1 + contextPath + servletMapping);
                    exchange2.getRequestFields().add("Cookie", sessionCookie);
                    client.send((HttpExchange)exchange2);
                    exchange2.waitForDone();
                    Assert.assertEquals((long)200L, (long)exchange2.getResponseStatus());
                    System.out.println("Checking: " + sessionTestValue + " vs " + exchange2.getResponseContent());
                    Assert.assertTrue((sessionTestValue < Long.parseLong(exchange2.getResponseContent()) ? 1 : 0) != 0);
                    sessionTestValue = Long.parseLong(exchange2.getResponseContent());
                    String setCookie = exchange1.getResponseFields().getStringField("Set-Cookie");
                    if (setCookie != null) {
                        sessionCookie = setCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                    }
                    Thread.sleep(requestInterval);
                }
            }
            finally {
                client.stop();
            }
        }
        finally {
            server1.stop();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("init".equals(action)) {
                HttpSession session = request.getSession(true);
                session.setAttribute("test", (Object)System.currentTimeMillis());
                this.sendResult(session, httpServletResponse.getWriter());
            } else {
                HttpSession session = request.getSession(false);
                System.out.println("not init call " + session);
                if (session != null) {
                    long value = System.currentTimeMillis();
                    System.out.println("Setting test to : " + value);
                    session.setAttribute("test", (Object)value);
                }
                this.sendResult(session, httpServletResponse.getWriter());
            }
        }

        private void sendResult(HttpSession session, PrintWriter writer) {
            if (session != null) {
                writer.print(session.getAttribute("test"));
            } else {
                writer.print(0);
            }
        }
    }
}

