/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.webapp.WebAppContext;

public abstract class AbstractTestServer {
    protected final Server _server;
    protected final int _maxInactivePeriod;
    protected final int _scavengePeriod;
    protected final ContextHandlerCollection _contexts;
    protected SessionIdManager _sessionIdManager;

    public AbstractTestServer(int port) {
        this(port, 30, 10);
    }

    public AbstractTestServer(int port, int maxInactivePeriod, int scavengePeriod) {
        this(port, maxInactivePeriod, scavengePeriod, null);
    }

    public AbstractTestServer(int port, int maxInactivePeriod, int scavengePeriod, String sessionIdMgrConfig) {
        this._server = new Server(port);
        this._maxInactivePeriod = maxInactivePeriod;
        this._scavengePeriod = scavengePeriod;
        this._contexts = new ContextHandlerCollection();
        this._sessionIdManager = this.newSessionIdManager(sessionIdMgrConfig);
        this._server.setSessionIdManager(this._sessionIdManager);
    }

    public abstract SessionIdManager newSessionIdManager(String var1);

    public abstract SessionManager newSessionManager();

    public abstract SessionHandler newSessionHandler(SessionManager var1);

    public void start() throws Exception {
        this._server.setHandler((Handler)this._contexts);
        this._server.start();
    }

    public int getPort() {
        return this._server.getConnectors()[0].getLocalPort();
    }

    public ServletContextHandler addContext(String contextPath) {
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)this._contexts, contextPath);
        SessionManager sessionManager = this.newSessionManager();
        sessionManager.setSessionIdManager(this._sessionIdManager);
        sessionManager.setMaxInactiveInterval(this._maxInactivePeriod);
        SessionHandler sessionHandler = this.newSessionHandler(sessionManager);
        sessionManager.setSessionHandler(sessionHandler);
        context.setSessionHandler(sessionHandler);
        return context;
    }

    public void stop() throws Exception {
        this._server.stop();
    }

    public void join() throws Exception {
        this._server.join();
    }

    public WebAppContext addWebAppContext(String warPath, String contextPath) {
        WebAppContext context = new WebAppContext((HandlerContainer)this._contexts, warPath, contextPath);
        SessionManager sessionManager = this.newSessionManager();
        sessionManager.setSessionIdManager(this._sessionIdManager);
        sessionManager.setMaxInactiveInterval(this._maxInactivePeriod);
        SessionHandler sessionHandler = this.newSessionHandler(sessionManager);
        sessionManager.setSessionHandler(sessionHandler);
        context.setSessionHandler(sessionHandler);
        return context;
    }

    public Server getServer() {
        return this._server;
    }
}

