/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.server.session.AbstractTestServer;
import org.eclipse.jetty.server.session.WebAppObjectInSessionServlet;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractWebAppObjectInSessionTest {
    public abstract AbstractTestServer createServer(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebappObjectInSession() throws Exception {
        String contextName = "webappObjectInSessionTest";
        String contextPath = "/" + contextName;
        String servletMapping = "/server";
        File targetDir = new File(System.getProperty("basedir"), "target");
        File warDir = new File(targetDir, contextName);
        warDir.mkdir();
        File webInfDir = new File(warDir, "WEB-INF");
        webInfDir.mkdir();
        File webXml = new File(webInfDir, "web.xml");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app xmlns=\"http://java.sun.com/xml/ns/j2ee\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\"\n         version=\"2.4\">\n\n</web-app>";
        FileWriter w = new FileWriter(webXml);
        w.write(xml);
        w.close();
        File classesDir = new File(webInfDir, "classes");
        classesDir.mkdir();
        String packageName = WebAppObjectInSessionServlet.class.getPackage().getName();
        File packageDirs = new File(classesDir, packageName.replace('.', File.separatorChar));
        packageDirs.mkdirs();
        String resourceName = WebAppObjectInSessionServlet.class.getSimpleName() + ".class";
        Resource resource = Resource.newResource((URL)this.getClass().getResource(resourceName));
        File targetFile = new File(packageDirs, resourceName);
        IO.copy((InputStream)resource.getInputStream(), (OutputStream)new FileOutputStream(targetFile));
        resourceName = WebAppObjectInSessionServlet.class.getSimpleName() + "$" + WebAppObjectInSessionServlet.TestSharedStatic.class.getSimpleName() + ".class";
        resource = Resource.newResource((URL)this.getClass().getResource(resourceName));
        targetFile = new File(packageDirs, resourceName);
        IO.copy((InputStream)resource.getInputStream(), (OutputStream)new FileOutputStream(targetFile));
        AbstractTestServer server1 = this.createServer(0);
        server1.addWebAppContext(warDir.getCanonicalPath(), contextPath).addServlet(WebAppObjectInSessionServlet.class.getName(), servletMapping);
        server1.start();
        int port1 = server1.getPort();
        try {
            AbstractTestServer server2 = this.createServer(0);
            server2.addWebAppContext(warDir.getCanonicalPath(), contextPath).addServlet(WebAppObjectInSessionServlet.class.getName(), servletMapping);
            server2.start();
            int port2 = server2.getPort();
            try {
                HttpClient client = new HttpClient();
                client.setConnectorType(0);
                client.start();
                try {
                    ContentExchange exchange1 = new ContentExchange(true);
                    exchange1.setMethod("GET");
                    exchange1.setURL("http://localhost:" + port1 + contextPath + servletMapping + "?action=set");
                    client.send((HttpExchange)exchange1);
                    exchange1.waitForDone();
                    Assert.assertEquals((long)200L, (long)exchange1.getResponseStatus());
                    String sessionCookie = exchange1.getResponseFields().getStringField("Set-Cookie");
                    Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                    sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                    ContentExchange exchange2 = new ContentExchange(true);
                    exchange2.setMethod("GET");
                    exchange2.setURL("http://localhost:" + port2 + contextPath + servletMapping + "?action=get");
                    exchange2.getRequestFields().add("Cookie", sessionCookie);
                    client.send((HttpExchange)exchange2);
                    exchange2.waitForDone();
                    Assert.assertEquals((long)200L, (long)exchange2.getResponseStatus());
                }
                finally {
                    client.stop();
                }
            }
            finally {
                server2.stop();
            }
        }
        finally {
            server1.stop();
        }
    }
}

