/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import jakarta.inject.Inject;
import java.time.YearMonth;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.Converter;
import org.eclipse.microprofile.config.tck.ParseConverterInjection;
import org.eclipse.microprofile.config.tck.base.AbstractTest;
import org.eclipse.microprofile.config.tck.converters.implicit.ConvTestSequenceOfBeforeValueOf;
import org.eclipse.microprofile.config.tck.converters.implicit.ConvTestSequenceParseBeforeConstructor;
import org.eclipse.microprofile.config.tck.converters.implicit.ConvTestSequenceValueOfBeforeParse;
import org.eclipse.microprofile.config.tck.converters.implicit.ConvTestTypeWCharSequenceParse;
import org.eclipse.microprofile.config.tck.converters.implicit.ConvTestTypeWStringCt;
import org.eclipse.microprofile.config.tck.converters.implicit.ConvTestTypeWStringOf;
import org.eclipse.microprofile.config.tck.converters.implicit.ConvTestTypeWStringValueOf;
import org.eclipse.microprofile.config.tck.converters.implicit.SomeEnumToConvert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ImplicitConverterTest
extends Arquillian {
    @Inject
    private Config config;
    @Inject
    private ParseConverterInjection parserConverterInjection;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"implicitConverterTest.jar")).addPackage(ConvTestTypeWStringCt.class.getPackage())).addClasses(new Class[]{ParseConverterInjection.class, ImplicitConverterTest.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        AbstractTest.addFile(testJar, "META-INF/microprofile-config.properties");
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"implicitConverterTest.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testImplicitConverterStringCt() {
        ConvTestTypeWStringCt value = (ConvTestTypeWStringCt)this.config.getValue("tck.config.test.javaconfig.converter.implicit.stringCt", ConvTestTypeWStringCt.class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)value.getVal(), (String)"stringCt");
    }

    @Test
    public void testImplicitConverterStringValueOf() {
        ConvTestTypeWStringValueOf value = (ConvTestTypeWStringValueOf)this.config.getValue("tck.config.test.javaconfig.converter.implicit.stringValueOf", ConvTestTypeWStringValueOf.class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)value.getVal(), (String)"stringValueOf");
    }

    @Test
    public void testImplicitConverterStringOf() {
        ConvTestTypeWStringOf value = (ConvTestTypeWStringOf)this.config.getValue("tck.config.test.javaconfig.converter.implicit.stringOf", ConvTestTypeWStringOf.class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)value.getVal(), (String)"stringOf");
    }

    @Test
    public void testImplicitConverterCharSequenceParse() {
        ConvTestTypeWCharSequenceParse value = (ConvTestTypeWCharSequenceParse)this.config.getValue("tck.config.test.javaconfig.converter.implicit.charSequenceParse", ConvTestTypeWCharSequenceParse.class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)value.getVal(), (String)"charSequenceParse");
    }

    @Test
    public void testImplicitConverterCharSequenceParseJavaTime() {
        YearMonth value = (YearMonth)this.config.getValue("tck.config.test.javaconfig.converter.implicit.charSequenceParse.yearmonth", YearMonth.class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)value, (Object)YearMonth.parse("2017-12"));
    }

    @Test
    public void testImplicitConverterCharSequenceParseJavaTimeInjection() {
        Assert.assertNotNull((Object)this.parserConverterInjection.getYearMonth());
        Assert.assertEquals((Object)this.parserConverterInjection.getYearMonth(), (Object)YearMonth.parse("2017-12"));
    }

    @Test
    public void testImplicitConverterEnumValueOf() {
        SomeEnumToConvert value = (SomeEnumToConvert)((Object)this.config.getValue("tck.config.test.javaconfig.converter.implicit.enumValueOf", SomeEnumToConvert.class));
        Assert.assertNotNull((Object)((Object)value));
        Assert.assertEquals((Object)((Object)value), (Object)((Object)SomeEnumToConvert.BAZ));
        Assert.assertEquals((String)value.name(), (String)"BAZ");
    }

    @Test
    public void testImplicitConverterSquenceOfBeforeValueOf() {
        ConvTestSequenceOfBeforeValueOf value = (ConvTestSequenceOfBeforeValueOf)this.config.getValue("tck.config.test.javaconfig.converter.implicit.sequence.ofBeforeValueOf", ConvTestSequenceOfBeforeValueOf.class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)value.getVal(), (String)"ofBeforeValueOf");
    }

    @Test
    public void testImplicitConverterSquenceValueOfBeforeParse() {
        ConvTestSequenceValueOfBeforeParse value = (ConvTestSequenceValueOfBeforeParse)this.config.getValue("tck.config.test.javaconfig.converter.implicit.sequence.valueOfBeforeParse", ConvTestSequenceValueOfBeforeParse.class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)value.getVal(), (String)"valueOfBeforeParse");
    }

    @Test
    public void testImplicitConverterSquenceParseBeforeConstructor() {
        ConvTestSequenceParseBeforeConstructor value = (ConvTestSequenceParseBeforeConstructor)this.config.getValue("tck.config.test.javaconfig.converter.implicit.sequence.parseBeforeConstructor", ConvTestSequenceParseBeforeConstructor.class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)value.getVal(), (String)"parseBeforeConstructor");
    }

    @Test
    public void testGetImplicitConverterStringCtConverter() {
        ConvTestTypeWStringCt value = (ConvTestTypeWStringCt)((Converter)this.config.getConverter(ConvTestTypeWStringCt.class).get()).convert("stringCt");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)value.getVal(), (String)"stringCt");
    }

    @Test
    public void testGetImplicitConverterStringValueOfConverter() {
        ConvTestTypeWStringValueOf value = (ConvTestTypeWStringValueOf)((Converter)this.config.getConverter(ConvTestTypeWStringValueOf.class).get()).convert("stringValueOf");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)value.getVal(), (String)"stringValueOf");
    }

    @Test
    public void testGetImplicitConverterStringOfConverter() {
        ConvTestTypeWStringOf value = (ConvTestTypeWStringOf)((Converter)this.config.getConverter(ConvTestTypeWStringOf.class).get()).convert("stringOf");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)value.getVal(), (String)"stringOf");
    }

    @Test
    public void testGetImplicitConverterCharSequenceParseConverter() {
        ConvTestTypeWCharSequenceParse value = (ConvTestTypeWCharSequenceParse)((Converter)this.config.getConverter(ConvTestTypeWCharSequenceParse.class).get()).convert("charSequenceParse");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)value.getVal(), (String)"charSequenceParse");
    }

    @Test
    public void testGetImplicitConverterCharSequenceParseJavaTimeConverter() {
        YearMonth value = (YearMonth)((Converter)this.config.getConverter(YearMonth.class).get()).convert("2017-12");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)value, (Object)YearMonth.parse("2017-12"));
    }

    @Test
    public void testGetImplicitConverterEnumValueOfConverter() {
        SomeEnumToConvert value = (SomeEnumToConvert)((Object)((Converter)this.config.getConverter(SomeEnumToConvert.class).get()).convert("BAZ"));
        Assert.assertNotNull((Object)((Object)value));
        Assert.assertEquals((Object)((Object)value), (Object)((Object)SomeEnumToConvert.BAZ));
        Assert.assertEquals((String)value.name(), (String)"BAZ");
    }

    @Test
    public void testGetImplicitConverterSquenceOfBeforeValueOfConverter() {
        ConvTestSequenceOfBeforeValueOf value = (ConvTestSequenceOfBeforeValueOf)((Converter)this.config.getConverter(ConvTestSequenceOfBeforeValueOf.class).get()).convert("ofBeforeValueOf");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)value.getVal(), (String)"ofBeforeValueOf");
    }

    @Test
    public void testGetImplicitConverterSquenceValueOfBeforeParseConverter() {
        ConvTestSequenceValueOfBeforeParse value = (ConvTestSequenceValueOfBeforeParse)((Converter)this.config.getConverter(ConvTestSequenceValueOfBeforeParse.class).get()).convert("valueOfBeforeParse");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)value.getVal(), (String)"valueOfBeforeParse");
    }

    @Test
    public void testGetImplicitConverterSquenceParseBeforeConstructorConverter() {
        ConvTestSequenceParseBeforeConstructor value = (ConvTestSequenceParseBeforeConstructor)((Converter)this.config.getConverter(ConvTestSequenceParseBeforeConstructor.class).get()).convert("parseBeforeConstructor");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)value.getVal(), (String)"parseBeforeConstructor");
    }
}

