/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck.profile;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class OverrideConfigProfileTest
extends Arquillian {
    private static final String PROPERTY = "mp.tck.prop.dummy";
    private static final String EXPECTED = "dummy";

    @Deployment
    public static WebArchive deployment() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"OverrideConfigProfileTest.war")).addClasses(new Class[]{OverrideConfigProfileTest.class, ProfilePropertyBean.class})).addAsResource((Asset)new StringAsset("mp.config.profile=dev\n%dev.mp.tck.prop.dummy=foo\nmp.tck.prop.dummy=bar\n"), "META-INF/microprofile-config.properties")).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return war;
    }

    @Test
    public void testConfigProfileWithDevAndOverride() {
        MatcherAssert.assertThat((Object)System.getProperty(PROPERTY), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)EXPECTED)));
        ProfilePropertyBean bean = (ProfilePropertyBean)CDI.current().select(ProfilePropertyBean.class, new Annotation[0]).get();
        MatcherAssert.assertThat((Object)bean.getConfigProperty(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)EXPECTED)));
        MatcherAssert.assertThat((Object)((String)ConfigProvider.getConfig().getValue(PROPERTY, String.class)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)EXPECTED)));
    }

    @Dependent
    public static class ProfilePropertyBean {
        @Inject
        @ConfigProperty(name="mp.tck.prop.dummy")
        private String stringProperty;

        public String getConfigProperty() {
            return this.stringProperty;
        }
    }
}

