/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.extras;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.BuildOutputDirectory;
import org.eclipse.tycho.p2.tools.DestinationRepositoryDescriptor;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2.tools.mirroring.facade.IUDescription;
import org.eclipse.tycho.p2.tools.mirroring.facade.MirrorApplicationService;
import org.eclipse.tycho.p2.tools.mirroring.facade.MirrorOptions;
import org.eclipse.tycho.plugins.p2.extras.Iu;
import org.eclipse.tycho.plugins.p2.extras.Repository;

@Mojo(name="mirror")
public class MirrorMojo
extends AbstractMojo {
    @Parameter(property="project")
    private MavenProject project;
    @Component
    private EquinoxServiceFactory p2;
    @Parameter(required=true)
    private List<Repository> source;
    @Parameter(defaultValue="${project.build.directory}/repository")
    private File destination;
    @Parameter
    private String name;
    @Parameter
    private List<Iu> ius;
    @Parameter(defaultValue="false")
    private boolean followStrictOnly;
    @Parameter(defaultValue="true")
    private boolean includeFeatures;
    @Parameter(defaultValue="true")
    private boolean includePacked;
    @Parameter(defaultValue="true")
    private boolean includeOptional;
    @Parameter(defaultValue="true")
    private boolean includeNonGreedy;
    @Parameter
    private Map<String, String> filter = new HashMap<String, String>();
    @Parameter(defaultValue="false")
    private boolean followOnlyFilteredRequirements;
    @Parameter(defaultValue="false")
    private boolean latestVersionOnly;
    @Parameter(defaultValue="false")
    private boolean mirrorMetadataOnly;
    @Parameter(defaultValue="true")
    private boolean compress;
    @Parameter(defaultValue="true")
    private boolean append;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MirrorApplicationService mirrorService = (MirrorApplicationService)this.p2.getService(MirrorApplicationService.class);
        RepositoryReferences sourceDescriptor = new RepositoryReferences();
        for (Repository sourceRepository : this.source) {
            if (sourceRepository.getLayout().hasMetadata()) {
                sourceDescriptor.addMetadataRepository(sourceRepository.getLocation());
            }
            if (!sourceRepository.getLayout().hasArtifacts()) continue;
            sourceDescriptor.addArtifactRepository(sourceRepository.getLocation());
        }
        if (this.name == null) {
            this.name = "";
        }
        DestinationRepositoryDescriptor destinationDescriptor = new DestinationRepositoryDescriptor(this.destination, this.name, this.compress, this.mirrorMetadataOnly, this.append);
        this.getLog().info((CharSequence)("Mirroring to " + this.destination + "..."));
        try {
            mirrorService.mirrorStandalone(sourceDescriptor, destinationDescriptor, this.createIUDescriptions(), this.createMirrorOptions(), this.getBuildOutputDirectory());
        }
        catch (FacadeException e) {
            throw new MojoExecutionException("Error during mirroring", (Exception)((Object)e));
        }
    }

    private MirrorOptions createMirrorOptions() {
        MirrorOptions options = new MirrorOptions();
        options.setFollowOnlyFilteredRequirements(this.followOnlyFilteredRequirements);
        options.setFollowStrictOnly(this.followStrictOnly);
        options.setIncludeFeatures(this.includeFeatures);
        options.setIncludeNonGreedy(this.includeNonGreedy);
        options.setIncludeOptional(this.includeOptional);
        options.setLatestVersionOnly(this.latestVersionOnly);
        options.getFilter().putAll(this.filter);
        options.setIncludePacked(this.includePacked);
        return options;
    }

    private Collection<IUDescription> createIUDescriptions() {
        if (this.ius == null) {
            return Collections.emptyList();
        }
        ArrayList<IUDescription> result = new ArrayList<IUDescription>();
        for (Iu iu : this.ius) {
            result.add(iu.toIUDescription());
        }
        return result;
    }

    private BuildOutputDirectory getBuildOutputDirectory() {
        return new BuildOutputDirectory(this.project.getBuild().getDirectory());
    }
}

