/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultTychoRepositoryIndex
implements TychoRepositoryIndex {
    private static final String ENCODING = "UTF8";
    private static final String EOL = "\n";
    private Set<GAV> gavs;

    protected DefaultTychoRepositoryIndex() {
        this(Collections.emptySet());
    }

    public DefaultTychoRepositoryIndex(Set<GAV> initialContent) {
        this.gavs = new LinkedHashSet<GAV>(initialContent);
    }

    @Override
    public Set<GAV> getProjectGAVs() {
        return Collections.unmodifiableSet(new LinkedHashSet<GAV>(this.gavs));
    }

    @Override
    public void addGav(GAV gav) {
        if (gav == null) {
            throw new NullPointerException();
        }
        this.gavs.add(gav);
    }

    @Override
    public void removeGav(GAV gav) {
        this.gavs.remove(gav);
    }

    protected void setGavs(Set<GAV> content) {
        this.gavs = content;
    }

    protected void write(OutputStream outStream) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(outStream), ENCODING);
        try {
            for (GAV gav : this.getProjectGAVs()) {
                out.write(gav.toExternalForm());
                out.write(EOL);
            }
            ((Writer)out).flush();
        }
        finally {
            ((Writer)out).close();
        }
    }

    protected Set<GAV> read(InputStream inStream) throws IOException {
        LinkedHashSet<GAV> result = new LinkedHashSet<GAV>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, ENCODING));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                GAV parsedGAV = GAV.parse(line);
                if (parsedGAV == null) continue;
                result.add(parsedGAV);
            }
        }
        finally {
            reader.close();
        }
        return result;
    }
}

