/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.impl.mirroring;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.mirroring.IArtifactMirrorLog;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.internal.repository.tools.SlicingOptions;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.tycho.p2.tools.BuildContext;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2.tools.TargetEnvironment;
import org.eclipse.tycho.p2.tools.impl.Activator;
import org.eclipse.tycho.p2.tools.impl.mirroring.MirrorApplication;
import org.eclipse.tycho.p2.tools.mirroring.MirrorApplicationService;
import org.eclipse.tycho.p2.util.StatusTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MirrorApplicationServiceImpl
implements MirrorApplicationService {
    private static final String MIRROR_FAILURE_MESSAGE = "Copying p2 repository content failed";

    public void mirror(RepositoryReferences sources, File destination, Collection<?> rootUnits, BuildContext context, int flags, String name) throws FacadeException {
        IProvisioningAgent agent = Activator.createProvisioningAgent(context.getTargetDirectory());
        try {
            MirrorApplication mirrorApp = new MirrorApplication(agent);
            MirrorApplicationServiceImpl.setSourceRepositories(mirrorApp, sources);
            RepositoryDescriptor destinationDescriptor = new RepositoryDescriptor();
            destinationDescriptor.setLocation(destination.toURI());
            destinationDescriptor.setAppend(true);
            destinationDescriptor.setName(name);
            boolean compressed = (flags & 1) != 0;
            destinationDescriptor.setCompressed(compressed);
            if ((flags & 4) == 0) {
                destinationDescriptor.setKind("M");
            }
            mirrorApp.addDestination(destinationDescriptor);
            mirrorApp.setSourceIUs(MirrorApplicationServiceImpl.toInstallableUnitList(rootUnits));
            SlicingOptions options = new SlicingOptions();
            boolean includeAllDepenendcies = (flags & 2) != 0;
            options.considerStrictDependencyOnly(!includeAllDepenendcies);
            for (TargetEnvironment environment : context.getEnvironments()) {
                HashMap filter = environment.toFilter();
                MirrorApplicationServiceImpl.addFilterForFeatureJARs(filter);
                options.setFilter((Map)filter);
                this.executeMirroring(mirrorApp, options);
            }
        }
        finally {
            agent.stop();
        }
    }

    private static void addFilterForFeatureJARs(Map<String, String> filter) {
        filter.put("org.eclipse.update.install.features", "true");
    }

    private void executeMirroring(MirrorApplication mirrorApp, SlicingOptions options) throws FacadeException {
        try {
            LogListener logListener = new LogListener();
            mirrorApp.setLog(logListener);
            mirrorApp.setSlicingOptions(options);
            IStatus returnStatus = mirrorApp.run(null);
            MirrorApplicationServiceImpl.checkStatus(returnStatus);
            for (IStatus logStatus : logListener.getSlicerProblems()) {
                MirrorApplicationServiceImpl.checkStatus(logStatus);
            }
        }
        catch (ProvisionException e) {
            throw new FacadeException("Copying p2 repository content failed: " + StatusTool.collectProblems((IStatus)e.getStatus()), (Throwable)e);
        }
    }

    private static void setSourceRepositories(MirrorApplication mirrorApp, RepositoryReferences sources) {
        MirrorApplicationServiceImpl.setSourceRepositories(mirrorApp, sources.getMetadataRepositories(), "M");
        MirrorApplicationServiceImpl.setSourceRepositories(mirrorApp, sources.getArtifactRepositories(), "A");
    }

    private static void setSourceRepositories(MirrorApplication mirrorApp, Collection<URI> repositoryLocations, String repositoryKind) {
        for (URI repositoryLocation : repositoryLocations) {
            RepositoryDescriptor repository = new RepositoryDescriptor();
            repository.setKind(repositoryKind);
            repository.setLocation(repositoryLocation);
            mirrorApp.addSource(repository);
        }
    }

    private static List<IInstallableUnit> toInstallableUnitList(Collection<?> units) {
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>(units.size());
        for (Object unit : units) {
            result.add((IInstallableUnit)unit);
        }
        return result;
    }

    private static void checkStatus(IStatus status) throws FacadeException {
        if (!status.isOK()) {
            throw new FacadeException("Copying p2 repository content failed: " + StatusTool.collectProblems((IStatus)status), status.getException());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LogListener
    implements IArtifactMirrorLog {
        List<IStatus> entries = new ArrayList<IStatus>();

        LogListener() {
        }

        public void log(IArtifactDescriptor descriptor, IStatus status) {
        }

        public void log(IStatus status) {
            this.entries.add(status);
        }

        public void close() {
        }

        List<IStatus> getSlicerProblems() {
            return this.entries;
        }
    }
}

