/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.impl.publisher;

import java.io.File;
import java.net.URI;
import java.util.List;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.p2.tools.BuildContext;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2.tools.TargetEnvironment;
import org.eclipse.tycho.p2.tools.impl.Activator;
import org.eclipse.tycho.p2.tools.impl.publisher.PublisherServiceImpl;
import org.eclipse.tycho.p2.tools.publisher.PublisherService;
import org.eclipse.tycho.p2.tools.publisher.PublisherServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublisherServiceFactoryImpl
implements PublisherServiceFactory {
    private static final boolean TARGET_REPOSITORY_COMPRESS = false;
    private static final String TARGET_REPOSITORY_NAME = "publisher repository";

    public PublisherService createPublisher(File targetRepository, RepositoryReferences contextRepos, BuildContext context) throws FacadeException {
        IProvisioningAgent agent = Activator.createProvisioningAgent(context.getTargetDirectory());
        try {
            PublisherInfo publisherInfo = new PublisherInfo();
            PublisherServiceFactoryImpl.setTargetMetadataRepository(publisherInfo, targetRepository, agent);
            PublisherServiceFactoryImpl.setTargetArtifactRepository(publisherInfo, targetRepository, agent);
            PublisherServiceFactoryImpl.setContextMetadataRepos(publisherInfo, contextRepos, agent);
            PublisherServiceFactoryImpl.setTargetEnvironments(publisherInfo, context.getEnvironments());
            return new PublisherServiceImpl(context, (IPublisherInfo)publisherInfo, agent);
        }
        catch (ProvisionException e) {
            agent.stop();
            throw new FacadeException((Throwable)e);
        }
    }

    private static void setTargetMetadataRepository(PublisherInfo publisherInfo, File location, IProvisioningAgent agent) throws ProvisionException {
        IMetadataRepository targetMetadataRepo = Publisher.createMetadataRepository((IProvisioningAgent)agent, (URI)location.toURI(), (String)TARGET_REPOSITORY_NAME, (boolean)true, (boolean)false);
        publisherInfo.setMetadataRepository(targetMetadataRepo);
    }

    private static void setTargetArtifactRepository(PublisherInfo publisherInfo, File location, IProvisioningAgent agent) throws ProvisionException {
        IArtifactRepository targetArtifactRepo = Publisher.createArtifactRepository((IProvisioningAgent)agent, (URI)location.toURI(), (String)TARGET_REPOSITORY_NAME, (boolean)false, (boolean)false);
        publisherInfo.setArtifactRepository(targetArtifactRepo);
        publisherInfo.setArtifactOptions(3);
    }

    private static void setContextMetadataRepos(PublisherInfo publisherInfo, RepositoryReferences contextRepos, IProvisioningAgent agent) {
        if (contextRepos.getMetadataRepositories().size() > 0) {
            CompositeMetadataRepository contextMetadataComposite = CompositeMetadataRepository.createMemoryComposite((IProvisioningAgent)agent);
            for (URI repositoryLocation : contextRepos.getMetadataRepositories()) {
                contextMetadataComposite.addChild(repositoryLocation);
            }
            publisherInfo.setContextMetadataRepository((IMetadataRepository)contextMetadataComposite);
        }
    }

    private static void setTargetEnvironments(PublisherInfo publisherInfo, List<TargetEnvironment> environments) {
        int writeIx = 0;
        String[] configSpecs = new String[environments.size()];
        for (TargetEnvironment environment : environments) {
            configSpecs[writeIx++] = environment.toConfigSpec();
        }
        publisherInfo.setConfigurations(configSpecs);
    }
}

