/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.impl.publisher;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.internal.p2.updatesite.CategoryXMLAction;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.eclipse.ProductAction;
import org.eclipse.tycho.p2.tools.BuildContext;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.impl.publisher.ResultSpyAction;
import org.eclipse.tycho.p2.tools.publisher.PublisherService;
import org.eclipse.tycho.p2.util.StatusTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublisherServiceImpl
implements PublisherService {
    private final BuildContext context;
    private final IPublisherInfo publisherInfo;
    private IProvisioningAgent agent;

    PublisherServiceImpl(BuildContext context, IPublisherInfo publisherInfo, IProvisioningAgent agent) {
        this.context = context;
        this.publisherInfo = publisherInfo;
        this.agent = agent;
    }

    public Collection<IInstallableUnit> publishCategories(File categoryDefinition) throws FacadeException, IllegalStateException {
        this.checkRunning();
        CategoryXMLAction categoryXMLAction = new CategoryXMLAction(categoryDefinition.toURI(), this.context.getQualifier());
        Collection<IInstallableUnit> allIUs = this.executePublisher((IPublisherAction)categoryXMLAction);
        return allIUs;
    }

    public Collection<IInstallableUnit> publishProduct(File productDefinition, File launcherBinaries, String flavor) throws FacadeException, IllegalStateException {
        this.checkRunning();
        ProductFile productDescriptor = null;
        try {
            productDescriptor = new ProductFile(productDefinition.getAbsolutePath());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load product file " + productDefinition.getAbsolutePath(), e);
        }
        Collection<IInstallableUnit> allIUs = this.executePublisher((IPublisherAction)new ProductAction(null, (IProductDescriptor)productDescriptor, flavor, launcherBinaries));
        return this.selectUnit(allIUs, productDescriptor.getId());
    }

    private Collection<IInstallableUnit> executePublisher(IPublisherAction action) throws FacadeException {
        ResultSpyAction resultSpy = new ResultSpyAction();
        Publisher publisher = new Publisher(this.publisherInfo);
        IPublisherAction[] actions = new IPublisherAction[]{action, resultSpy};
        IStatus result = publisher.publish(actions, null);
        if (!result.isOK()) {
            throw new FacadeException(StatusTool.collectProblems((IStatus)result), result.getException());
        }
        return resultSpy.getAllIUs();
    }

    private Collection<IInstallableUnit> selectUnit(Collection<IInstallableUnit> units, String id) {
        for (IInstallableUnit unit : units) {
            if (!id.equals(unit.getId())) continue;
            return Collections.singleton(unit);
        }
        throw new IllegalStateException("ProductAction did not produce product IU");
    }

    public void stop() {
        if (this.agent != null) {
            this.agent.stop();
            this.agent = null;
        }
    }

    private void checkRunning() throws IllegalStateException {
        if (this.agent == null) {
            throw new IllegalStateException("Attempt to access stopped publisher service: " + this);
        }
    }
}

