/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.publisher;

import java.net.URI;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.p2.tools.BuildContext;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2.tools.TargetEnvironment;
import org.eclipse.tycho.repository.publishing.PublishingRepository;
import org.eclipse.tycho.repository.registry.ReactorRepositoryManager;

class PublisherInfoTemplate {
    private final RepositoryReferences contextRepos;
    private final BuildContext context;
    private ReactorRepositoryManager reactorRepoManager;

    public PublisherInfoTemplate(RepositoryReferences contextRepos, BuildContext context, ReactorRepositoryManager reactorRepositoryManager) {
        this.contextRepos = contextRepos;
        this.context = context;
        this.reactorRepoManager = reactorRepositoryManager;
    }

    public IPublisherInfo newPublisherInfo(PublishingRepository publishingRepo) throws FacadeException {
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setMetadataRepository(publishingRepo.getMetadataRepository());
        publisherInfo.setArtifactRepository(publishingRepo.getArtifactRepository());
        publisherInfo.setArtifactOptions(3);
        this.setContextMetadataRepos(publisherInfo);
        this.setTargetEnvironments(publisherInfo);
        return publisherInfo;
    }

    private void setContextMetadataRepos(PublisherInfo publisherInfo) {
        if (this.contextRepos.getMetadataRepositories().size() > 0) {
            CompositeMetadataRepository contextMetadataComposite = CompositeMetadataRepository.createMemoryComposite((IProvisioningAgent)this.reactorRepoManager.getAgent());
            for (URI repositoryLocation : this.contextRepos.getMetadataRepositories()) {
                contextMetadataComposite.addChild(repositoryLocation);
            }
            publisherInfo.setContextMetadataRepository((IMetadataRepository)contextMetadataComposite);
        }
    }

    private void setTargetEnvironments(PublisherInfo publisherInfo) {
        int writeIx = 0;
        String[] configSpecs = new String[this.context.getEnvironments().size()];
        for (TargetEnvironment environment : this.context.getEnvironments()) {
            configSpecs[writeIx++] = environment.toConfigSpec();
        }
        publisherInfo.setConfigurations(configSpecs);
    }
}

