/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.publisher;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.tycho.artifacts.DependencyResolutionException;
import org.eclipse.tycho.artifacts.IllegalArtifactReferenceException;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.target.P2TargetPlatform;

class ProductVersionExpansionRun {
    private final P2TargetPlatform targetPlatform;
    private final File productFile;
    StringBuilder errors = null;

    ProductVersionExpansionRun(P2TargetPlatform targetPlatform, File productFile) {
        this.targetPlatform = targetPlatform;
        this.productFile = productFile;
    }

    public List<IVersionedId> resolveReferences(String elementName, String artifactType, List<IVersionedId> references) {
        ArrayList<IVersionedId> result = new ArrayList<IVersionedId>();
        for (IVersionedId reference : references) {
            IInstallableUnit resolvedUnit = this.resolveReferenceWithErrorHandling(elementName, artifactType, reference);
            if (resolvedUnit == null) continue;
            result.add((IVersionedId)new VersionedId(reference.getId(), resolvedUnit.getVersion()));
        }
        return result;
    }

    public List<IInstallableUnit> resolveReferencesToIUs(String elementName, String artifactType, List<IVersionedId> references) {
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>();
        for (IVersionedId reference : references) {
            IInstallableUnit resolvedUnit = this.resolveReferenceWithErrorHandling(elementName, artifactType, reference);
            if (resolvedUnit == null) continue;
            result.add(resolvedUnit);
        }
        return result;
    }

    private IInstallableUnit resolveReferenceWithErrorHandling(String elementName, String artifactType, IVersionedId reference) {
        try {
            return this.targetPlatform.resolveUnit(artifactType, reference.getId(), reference.getVersion());
        }
        catch (IllegalArtifactReferenceException e) {
            this.errors = this.initReferenceResolutionError(this.errors);
            this.errors.append("  Invalid <").append(elementName).append("> element with id=").append(ProductVersionExpansionRun.quote(reference.getId()));
            if (reference.getVersion() != null) {
                this.errors.append(" and version=").append(ProductVersionExpansionRun.quote(reference.getVersion()));
            }
            this.errors.append(": ").append(e.getMessage()).append('\n');
        }
        catch (DependencyResolutionException e) {
            this.errors = this.initReferenceResolutionError(this.errors);
            this.errors.append("  ").append(e.getMessage()).append('\n');
        }
        return null;
    }

    public void reportErrors(MavenLogger logger) {
        if (this.errors != null) {
            logger.error(this.errors.toString());
            throw new DependencyResolutionException("Cannot resolve dependencies of product " + this.productFile.getName() + ". See log for details.");
        }
    }

    private StringBuilder initReferenceResolutionError(StringBuilder errors) {
        if (errors == null) {
            return new StringBuilder("Cannot resolve dependencies of product " + this.productFile.getName() + ":\n");
        }
        return errors;
    }

    private static String quote(Object nullableObject) {
        if (nullableObject == null) {
            return null;
        }
        return "\"" + nullableObject + "\"";
    }
}

