/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.surefire.common.junit4.JUnit4RunListenerFactory;
import org.apache.maven.surefire.common.junit4.JUnit4TestChecker;
import org.apache.maven.surefire.junitcore.ConcurrentReporterManager;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.junitcore.JUnitCoreWrapper;
import org.apache.maven.surefire.junitcore.OsgiEnabledJUnitCoreRunListener;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ConsoleLogger;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.DirectoryScanner;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.junit.runner.notification.RunListener;

public class OsgiEnabledJUnitCoreProvider
extends AbstractProvider {
    private final ClassLoader testClassLoader;
    private final DirectoryScanner directoryScanner;
    private final JUnitCoreParameters jUnitCoreParameters;
    private final ScannerFilter scannerFilter;
    private final List<RunListener> customRunListeners;
    private final ProviderParameters providerParameters;
    private TestsToRun testsToRun;

    public OsgiEnabledJUnitCoreProvider(ProviderParameters providerParameters) {
        this.providerParameters = providerParameters;
        this.testClassLoader = providerParameters.getTestClassLoader();
        this.directoryScanner = providerParameters.getDirectoryScanner();
        this.jUnitCoreParameters = new JUnitCoreParameters(providerParameters.getProviderProperties());
        this.scannerFilter = new JUnit4TestChecker(this.testClassLoader);
        this.customRunListeners = JUnit4RunListenerFactory.createCustomListeners((String)providerParameters.getProviderProperties().getProperty("listener"));
    }

    public Boolean isRunnable() {
        return Boolean.TRUE;
    }

    public Iterator getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun.iterator();
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        String message = "Concurrency config is " + this.jUnitCoreParameters.toString() + "\n";
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        ConsoleLogger consoleLogger = this.providerParameters.getConsoleLogger();
        consoleLogger.info(message);
        if (this.testsToRun == null) {
            this.testsToRun = forkTestSet == null ? this.scanClassPath() : TestsToRun.fromClass((Class)((Class)forkTestSet));
        }
        ConcurrentHashMap<String, TestSet> testSetMap = new ConcurrentHashMap<String, TestSet>();
        ConcurrentReporterManager listener = ConcurrentReporterManager.createInstance(testSetMap, (ReporterFactory)reporterFactory, (boolean)this.jUnitCoreParameters.isParallelClasses(), (boolean)this.jUnitCoreParameters.isParallelBoth(), (ConsoleLogger)consoleLogger);
        ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)((ConsoleOutputReceiver)listener));
        OsgiEnabledJUnitCoreRunListener jUnit4RunListener = new OsgiEnabledJUnitCoreRunListener((org.apache.maven.surefire.report.RunListener)listener, testSetMap);
        this.customRunListeners.add(0, (RunListener)jUnit4RunListener);
        JUnitCoreWrapper.execute((TestsToRun)this.testsToRun, (JUnitCoreParameters)this.jUnitCoreParameters, this.customRunListeners);
        return reporterFactory.close();
    }

    private TestsToRun scanClassPath() {
        return this.directoryScanner.locateTestClasses(this.testClassLoader, this.scannerFilter);
    }
}

