/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.updatesite.CategoryParser;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.osgi.framework.util.CaseInsensitiveDictionaryMap;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.helper.PluginRealmHelper;
import org.eclipse.tycho.p2maven.InstallableUnitPublisher;
import org.eclipse.tycho.p2maven.actions.AuthoredIUAction;
import org.eclipse.tycho.p2maven.actions.CategoryDependenciesAction;
import org.eclipse.tycho.p2maven.actions.FeatureDependenciesAction;
import org.eclipse.tycho.p2maven.actions.ProductDependenciesAction;
import org.eclipse.tycho.p2maven.actions.ProductFile2;
import org.eclipse.tycho.p2maven.io.MetadataIO;
import org.eclipse.tycho.p2maven.tmp.BundlesAction;
import org.eclipse.tycho.resolver.InstallableUnitProvider;
import org.xml.sax.SAXException;

@Component(role=InstallableUnitGenerator.class)
public class InstallableUnitGenerator {
    private static final boolean DUMP_DATA = Boolean.getBoolean("tycho.p2.dump") || Boolean.getBoolean("tycho.p2.dump.units");
    @Requirement
    private Logger log;
    private static final String KEY_UNITS = "InstallableUnitGenerator.units";
    @Requirement
    private IProvisioningAgent provisioningAgent;
    @Requirement(role=InstallableUnitProvider.class)
    private Map<String, InstallableUnitProvider> additionalUnitProviders;
    @Requirement
    private PluginRealmHelper pluginRealmHelper;
    @Requirement
    private InstallableUnitPublisher publisher;
    @Requirement
    private PlexusContainer plexus;
    @Requirement
    ArtifactHandlerManager artifactHandlerManager;
    private Map<Artifact, ArtifactUnits> artifactUnitMap = new ConcurrentHashMap<Artifact, ArtifactUnits>();

    public Map<MavenProject, Collection<IInstallableUnit>> getInstallableUnits(Collection<MavenProject> projects, MavenSession session) throws CoreException {
        this.init();
        Objects.requireNonNull(session);
        CopyOnWriteArrayList errors = new CopyOnWriteArrayList();
        ConcurrentHashMap<MavenProject, Collection<IInstallableUnit>> result = new ConcurrentHashMap<MavenProject, Collection<IInstallableUnit>>();
        ((Stream)projects.parallelStream().unordered()).takeWhile(nil -> errors.isEmpty()).forEach(project -> {
            try {
                result.put((MavenProject)project, this.getInstallableUnits((MavenProject)project, session, false));
            }
            catch (CoreException e) {
                errors.add(e);
            }
        });
        if (errors.isEmpty()) {
            return result;
        }
        if (errors.size() == 1) {
            throw (CoreException)((Object)errors.get(0));
        }
        MultiStatus multiStatus = new MultiStatus(InstallableUnitGenerator.class, 4, "computing installable unit units failed");
        errors.forEach(e -> multiStatus.add(e.getStatus()));
        throw new CoreException((IStatus)multiStatus);
    }

    private void init() {
        this.provisioningAgent.getService(IArtifactRepositoryManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IInstallableUnit> getInstallableUnits(MavenProject project, MavenSession session, boolean forceUpdate) throws CoreException {
        this.init();
        Objects.requireNonNull(session);
        this.log.debug("Computing installable units for " + project + ", force update = " + forceUpdate);
        MavenProject mavenProject = project;
        synchronized (mavenProject) {
            File basedir;
            Object contextValue;
            if (!forceUpdate && (contextValue = project.getContextValue(KEY_UNITS)) instanceof Collection) {
                Collection collection = (Collection)contextValue;
                if (InstallableUnitGenerator.isCompatible(collection)) {
                    this.log.debug("Using cached value for " + project);
                    return collection;
                }
                this.log.debug("Cannot use cached value for " + project + " because of incompatible classloaders, update is forced");
            }
            if ((basedir = project.getBasedir()) == null || !basedir.isDirectory()) {
                this.log.warn("No valid basedir for " + project + " found");
                return Collections.emptyList();
            }
            String packaging = project.getPackaging();
            String version = project.getVersion();
            String artifactId = project.getArtifactId();
            List<IPublisherAction> actions = this.getPublisherActions(packaging, basedir, version, artifactId);
            Collection<IInstallableUnit> publishedUnits = this.publisher.publishMetadata(actions);
            for (InstallableUnitProvider unitProvider : this.getProvider(project, session)) {
                this.log.debug("Asking " + unitProvider + " for additional units for " + project);
                Collection installableUnits = unitProvider.getInstallableUnits(project, session);
                this.log.debug("Provider " + unitProvider + " generated " + installableUnits.size() + " (" + installableUnits + ") units for " + project);
                publishedUnits.addAll(installableUnits);
            }
            Collection<IInstallableUnit> result = Collections.unmodifiableCollection(publishedUnits);
            if (DUMP_DATA) {
                File file = new File(project.getBasedir(), "project-units.xml");
                try {
                    new MetadataIO().writeXML(result, file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (result.isEmpty()) {
                this.log.debug("Cannot generate any InstallableUnit for packaging type '" + packaging + "' for " + project);
            }
            project.setContextValue(KEY_UNITS, result);
            return result;
        }
    }

    private List<IPublisherAction> getPublisherActions(String packaging, File basedir, String version, String artifactId) throws CoreException {
        ArrayList<IPublisherAction> actions = new ArrayList<IPublisherAction>();
        switch (packaging) {
            case "eclipse-test-plugin": 
            case "eclipse-plugin": {
                actions.add((IPublisherAction)new BundlesAction(new File[]{basedir}));
                break;
            }
            case "eclipse-feature": {
                FeatureParser parser = new FeatureParser();
                Feature feature = parser.parse(basedir);
                feature.setLocation(basedir.getAbsolutePath());
                FeatureDependenciesAction action = new FeatureDependenciesAction(feature);
                actions.add((IPublisherAction)action);
                break;
            }
            case "eclipse-repository": {
                File categoryFile = new File(basedir, "category.xml");
                if (categoryFile.exists()) {
                    try (FileInputStream stream = new FileInputStream(categoryFile);){
                        SiteModel siteModel = new CategoryParser(null).parse((InputStream)stream);
                        actions.add((IPublisherAction)new CategoryDependenciesAction(siteModel, artifactId, version));
                    }
                    catch (IOException | SAXException e) {
                        throw new CoreException(Status.error((String)("Error reading " + categoryFile.getAbsolutePath())));
                    }
                }
                for (File f : basedir.listFiles(File::isFile)) {
                    if (!f.getName().endsWith(".product") || f.getName().startsWith(".polyglot")) continue;
                    try {
                        ProductFile2 productDescriptor = new ProductFile2(f.getAbsolutePath());
                        actions.add((IPublisherAction)new ProductDependenciesAction((IProductDescriptor)productDescriptor));
                    }
                    catch (CoreException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new CoreException(Status.error((String)("Error reading " + f.getAbsolutePath() + ": " + e), (Throwable)e));
                    }
                }
                break;
            }
            case "p2-installable-unit": {
                actions.add(new AuthoredIUAction(basedir));
                break;
            }
        }
        return actions;
    }

    public Collection<IInstallableUnit> getInstallableUnits(IProductDescriptor productDescriptor) throws CoreException {
        return this.publisher.publishMetadata(List.of(new ProductDependenciesAction(productDescriptor)));
    }

    public Collection<IInstallableUnit> getInstallableUnits(Manifest manifest) {
        Attributes mainAttributes = manifest.getMainAttributes();
        CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap(mainAttributes.size());
        Set<Map.Entry<Object, Object>> entrySet = mainAttributes.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            headers.put((Object)entry.getKey().toString(), (Object)entry.getValue().toString());
        }
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setArtifactOptions(1);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((Dictionary<String, String>)headers, null);
        IInstallableUnit iu = BundlesAction.createBundleIU(bundleDescription, BundlesAction.createBundleArtifactKey(bundleDescription.getSymbolicName(), bundleDescription.getVersion().toString()), (IPublisherInfo)publisherInfo);
        return List.of(iu);
    }

    public Collection<IInstallableUnit> getInstallableUnits(Artifact artifact) {
        return this.artifactUnitMap.computeIfAbsent(artifact, x -> new ArtifactUnits()).getUnits(artifact);
    }

    public Collection<IInstallableUnit> getProvidedInstallableUnits(ReactorProject reactorProject) {
        MavenProject mavenProject = (MavenProject)reactorProject.adapt(MavenProject.class);
        MavenSession mavenSession = (MavenSession)reactorProject.adapt(MavenSession.class);
        try {
            return this.getProvider(mavenProject, mavenSession).stream().flatMap(provider -> {
                try {
                    return provider.getInstallableUnits(mavenProject, mavenSession).stream();
                }
                catch (CoreException e) {
                    return Stream.empty();
                }
            }).toList();
        }
        catch (CoreException e) {
            return List.of();
        }
    }

    private Collection<InstallableUnitProvider> getProvider(MavenProject project, MavenSession mavenSession) throws CoreException {
        HashSet<InstallableUnitProvider> unitProviders = new HashSet<InstallableUnitProvider>(this.additionalUnitProviders.values());
        try {
            this.pluginRealmHelper.visitPluginExtensions(project, mavenSession, InstallableUnitProvider.class, unitProviders::add);
        }
        catch (Exception e) {
            throw new CoreException(Status.error((String)"Can't lookup InstallableUnitProviders", (Throwable)e));
        }
        return unitProviders;
    }

    private static boolean isCompatible(Collection<?> collection) {
        if (collection.isEmpty()) {
            return true;
        }
        for (Object unit : collection) {
            if (IInstallableUnit.class.isInstance(unit)) continue;
            return false;
        }
        return true;
    }

    private final class ArtifactUnits {
        private Collection<IInstallableUnit> units;
        private long lastModified;

        private ArtifactUnits() {
        }

        public synchronized Collection<IInstallableUnit> getUnits(Artifact artifact) {
            block14: {
                if (this.units != null && !this.hasChanges(artifact)) {
                    return this.units;
                }
                try {
                    List<IPublisherAction> actions;
                    File file = artifact.getFile();
                    if (!this.isValidFile(file)) break block14;
                    this.lastModified = file.lastModified();
                    String type = artifact.getType();
                    if ("eclipse-plugin".equals(type) || "eclipse-test-plugin".equals(type) || "bundle".equals(type)) {
                        List<IPublisherAction> actions2 = InstallableUnitGenerator.this.getPublisherActions("eclipse-plugin", file, artifact.getVersion(), artifact.getArtifactId());
                        this.units = InstallableUnitGenerator.this.publisher.publishMetadata(actions2);
                        return this.units;
                    }
                    if ("eclipse-feature".equals(type)) {
                        List<IPublisherAction> actions3 = InstallableUnitGenerator.this.getPublisherActions("eclipse-feature", file, artifact.getVersion(), artifact.getArtifactId());
                        this.units = InstallableUnitGenerator.this.publisher.publishMetadata(actions3);
                        return this.units;
                    }
                    boolean isBundle = false;
                    boolean isFeature = false;
                    try (JarFile jarFile2 = new JarFile(file);){
                        Manifest manifest = jarFile2.getManifest();
                        isBundle = manifest != null && manifest.getMainAttributes().getValue("Bundle-SymbolicName") != null;
                        isFeature = jarFile2.getEntry("feature.xml") != null;
                    }
                    catch (IOException jarFile2) {
                        // empty catch block
                    }
                    if (isBundle) {
                        actions = InstallableUnitGenerator.this.getPublisherActions("eclipse-plugin", file, artifact.getVersion(), artifact.getArtifactId());
                        this.units = InstallableUnitGenerator.this.publisher.publishMetadata(actions);
                        return this.units;
                    }
                    if (isFeature) {
                        actions = InstallableUnitGenerator.this.getPublisherActions("eclipse-feature", file, artifact.getVersion(), artifact.getArtifactId());
                        this.units = InstallableUnitGenerator.this.publisher.publishMetadata(actions);
                        return this.units;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            this.units = Collections.emptyList();
            return this.units;
        }

        private boolean isValidFile(File file) {
            return file != null && file.getName().toLowerCase().endsWith(".jar") && file.exists();
        }

        private boolean hasChanges(Artifact artifact) {
            File file = artifact.getFile();
            if (this.isValidFile(file)) {
                return file.lastModified() != this.lastModified;
            }
            return false;
        }
    }
}

