/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.CollectionResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.tycho.p2maven.InstallableUnitGenerator;
import org.eclipse.tycho.p2maven.InstallableUnitSlicer;
import org.eclipse.tycho.p2maven.io.MetadataIO;

@Component(role=MavenProjectDependencyProcessor.class)
public class MavenProjectDependencyProcessor {
    private static final ProjectDependencies EMPTY_DEPENDENCIES = new ProjectDependencies(Map.of(), Set.of());
    private static final boolean DUMP_DATA = Boolean.getBoolean("tycho.p2.dump") || Boolean.getBoolean("tycho.p2.dump.dependencies");
    @Requirement
    private InstallableUnitGenerator generator;
    @Requirement
    private InstallableUnitSlicer slicer;

    public ProjectDependencyClosure computeProjectDependencyClosure(Collection<MavenProject> projects, MavenSession session) throws CoreException {
        Objects.requireNonNull(session);
        final Map<MavenProject, Collection<IInstallableUnit>> projectIUMap = this.generator.getInstallableUnits(projects, session);
        Collection availableIUs = projectIUMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        final Map<MavenProject, ProjectDependencies> projectDependenciesMap = this.computeProjectDependencies(projects, (IQueryable<IInstallableUnit>)new CollectionResult(availableIUs), projectIUMap);
        final HashMap<IInstallableUnit, MavenProject> iuProjectMap = new HashMap<IInstallableUnit, MavenProject>();
        for (Map.Entry<MavenProject, Collection<IInstallableUnit>> entry : projectIUMap.entrySet()) {
            MavenProject mavenProject = entry.getKey();
            for (IInstallableUnit iu : entry.getValue()) {
                iuProjectMap.put(iu, mavenProject);
            }
        }
        return new ProjectDependencyClosure(){

            @Override
            public Optional<MavenProject> getProject(IInstallableUnit installableUnit) {
                return Optional.ofNullable((MavenProject)iuProjectMap.get(installableUnit));
            }

            @Override
            public ProjectDependencies getProjectDependecies(MavenProject mavenProject) {
                return projectDependenciesMap.getOrDefault(mavenProject, EMPTY_DEPENDENCIES);
            }

            @Override
            public Stream<Map.Entry<MavenProject, Collection<IInstallableUnit>>> dependencies(Function<MavenProject, Collection<IInstallableUnit>> contextIuSupplier) {
                return projectDependenciesMap.entrySet().stream().map(pd -> new AbstractMap.SimpleEntry<MavenProject, Collection<IInstallableUnit>>((MavenProject)pd.getKey(), ((ProjectDependencies)pd.getValue()).getDependencies((Collection)contextIuSupplier.apply((MavenProject)pd.getKey()))));
            }

            @Override
            public boolean isFragment(MavenProject mavenProject) {
                return this.getProjectUnits(mavenProject).stream().anyMatch(MavenProjectDependencyProcessor::isFragment);
            }

            @Override
            public Collection<IInstallableUnit> getProjectUnits(MavenProject mavenProject) {
                Collection collection = (Collection)projectIUMap.get(mavenProject);
                if (collection != null) {
                    return collection;
                }
                return Collections.emptyList();
            }
        };
    }

    private Map<MavenProject, ProjectDependencies> computeProjectDependencies(Collection<MavenProject> projects, IQueryable<IInstallableUnit> avaiableIUs, Map<MavenProject, Collection<IInstallableUnit>> projectIUMap) throws CoreException {
        CopyOnWriteArrayList errors = new CopyOnWriteArrayList();
        ConcurrentHashMap<MavenProject, ProjectDependencies> result = new ConcurrentHashMap<MavenProject, ProjectDependencies>();
        ((Stream)projects.parallelStream().unordered()).takeWhile(nil -> errors.isEmpty()).forEach(project -> {
            try {
                ProjectDependencies projectDependencies = this.computeProjectDependencies(Set.copyOf((Collection)projectIUMap.get(project)), avaiableIUs);
                result.put((MavenProject)project, projectDependencies);
                if (DUMP_DATA) {
                    File file = new File(project.getBasedir(), "project-dependencies.xml");
                    try {
                        new MetadataIO().writeXML(Collections.unmodifiableCollection(projectDependencies.getDependencies(List.of())), file);
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (CoreException e) {
                errors.add(e);
            }
        });
        if (errors.isEmpty()) {
            return result;
        }
        if (errors.size() == 1) {
            throw (CoreException)((Object)errors.get(0));
        }
        MultiStatus multiStatus = new MultiStatus(InstallableUnitGenerator.class, 4, "computing installable unit units failed");
        errors.forEach(e -> multiStatus.add(e.getStatus()));
        throw new CoreException((IStatus)multiStatus);
    }

    private ProjectDependencies computeProjectDependencies(Set<IInstallableUnit> projectUnits, IQueryable<IInstallableUnit> avaiableIUs) throws CoreException {
        if (projectUnits.isEmpty()) {
            return EMPTY_DEPENDENCIES;
        }
        Map<IRequirement, Collection<IInstallableUnit>> dependencies = this.slicer.computeDirectDependencies(projectUnits, avaiableIUs);
        return new ProjectDependencies(dependencies, projectUnits);
    }

    private static boolean hasAnyHost(IInstallableUnit unit, Iterable<IInstallableUnit> collection) {
        return MavenProjectDependencyProcessor.getFragmentHostRequirement(unit).anyMatch(req -> {
            for (IInstallableUnit iu : collection) {
                if (!req.isMatch(iu)) continue;
                return true;
            }
            return false;
        });
    }

    private static boolean isFragment(IInstallableUnit installableUnit) {
        return MavenProjectDependencyProcessor.getFragmentCapability(installableUnit).findAny().isPresent();
    }

    private static Stream<IProvidedCapability> getFragmentCapability(IInstallableUnit installableUnit) {
        return installableUnit.getProvidedCapabilities().stream().filter(cap -> "osgi.fragment".equals(cap.getNamespace()));
    }

    private static Stream<IRequirement> getFragmentHostRequirement(IInstallableUnit installableUnit) {
        return MavenProjectDependencyProcessor.getFragmentCapability(installableUnit).map(provided -> {
            String hostName = provided.getName();
            for (IRequirement requirement : installableUnit.getRequirements()) {
                IRequiredCapability requiredCapability;
                if (!(requirement instanceof IRequiredCapability) || !hostName.equals((requiredCapability = (IRequiredCapability)requirement).getName())) continue;
                return requirement;
            }
            return null;
        }).filter(Objects::nonNull);
    }

    private static boolean isMatch(IRequirement requirement, Collection<IInstallableUnit> contextIUs) {
        IMatchExpression filter = requirement.getFilter();
        if (filter == null || contextIUs.isEmpty()) {
            return true;
        }
        return contextIUs.stream().anyMatch(contextIU -> filter.isMatch(contextIU));
    }

    public static final class ProjectDependencies {
        private final Map<IRequirement, Collection<IInstallableUnit>> requirementsMap;
        private final Set<IInstallableUnit> projectUnits;

        ProjectDependencies(Map<IRequirement, Collection<IInstallableUnit>> requirementsMap, Set<IInstallableUnit> projectUnits) {
            this.requirementsMap = requirementsMap;
            this.projectUnits = projectUnits;
        }

        public Collection<IInstallableUnit> getDependencies(Collection<IInstallableUnit> contextIUs) {
            return this.requirementsMap.entrySet().stream().filter(entry -> MavenProjectDependencyProcessor.isMatch((IRequirement)entry.getKey(), contextIUs)).flatMap(entry -> ((Collection)entry.getValue()).stream().filter(unit -> !this.projectUnits.contains(unit)).limit(((IRequirement)entry.getKey()).getMax())).distinct().toList();
        }
    }

    public static interface ProjectDependencyClosure {
        public Optional<MavenProject> getProject(IInstallableUnit var1);

        public ProjectDependencies getProjectDependecies(MavenProject var1);

        public Collection<IInstallableUnit> getProjectUnits(MavenProject var1);

        public Stream<Map.Entry<MavenProject, Collection<IInstallableUnit>>> dependencies(Function<MavenProject, Collection<IInstallableUnit>> var1);

        default public Collection<MavenProject> getDependencyProjects(MavenProject mavenProject, Collection<IInstallableUnit> contextIUs) {
            ProjectDependencies projectDependecies = this.getProjectDependecies(mavenProject);
            List<MavenProject> list = projectDependecies.getDependencies(contextIUs).stream().flatMap(dependency -> this.getProject((IInstallableUnit)dependency).stream()).distinct().toList();
            if (this.isFragment(mavenProject)) {
                return list;
            }
            return list.stream().flatMap(project -> {
                ProjectDependencies dependecies = this.getProjectDependecies((MavenProject)project);
                return Stream.concat(Stream.of(project), dependecies.getDependencies(contextIUs).stream().filter(dep -> MavenProjectDependencyProcessor.hasAnyHost(dep, dependecies.projectUnits)).flatMap(dependency -> this.getProject((IInstallableUnit)dependency).stream()));
            }).toList();
        }

        public boolean isFragment(MavenProject var1);
    }
}

