/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.equinox.internal.p2.repository.DownloadStatus;

public class DownloadStatusOutputStream
extends OutputStream {
    private final long startTime = System.currentTimeMillis();
    private final OutputStream delegate;
    private long bytesWritten;
    private long endTime;
    private IOException exception;
    private String message;

    public DownloadStatusOutputStream(OutputStream out, String message) {
        this.delegate = out;
        this.message = message;
    }

    public DownloadStatus getStatus() {
        DownloadStatus status = new DownloadStatus(this.exception == null ? 0 : 4, "org.eclipse.tycho", this.message, (Throwable)this.exception);
        if (this.bytesWritten > 0L) {
            status.setFileSize(this.bytesWritten);
            long stopTime = this.endTime > 0L ? this.endTime : System.currentTimeMillis();
            status.setTransferRate(this.bytesWritten / Math.max(stopTime - this.startTime, 1L) * 1000L);
        }
        return status;
    }

    @Override
    public void write(int val) throws IOException {
        try {
            this.delegate.write(val);
        }
        catch (IOException e) {
            this.exception = e;
            throw e;
        }
        ++this.bytesWritten;
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        try {
            this.delegate.write(buf, off, len);
            this.bytesWritten += (long)len;
        }
        catch (IOException e) {
            this.exception = e;
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.delegate.flush();
        }
        catch (IOException e) {
            this.exception = e;
            throw e;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.delegate.write(b);
            this.bytesWritten += (long)b.length;
        }
        catch (IOException e) {
            this.exception = e;
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            this.exception = e;
            throw e;
        }
        this.endTime = System.currentTimeMillis();
    }
}

