/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.advices;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Map;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;

public class MavenChecksumAdvice
implements IPropertyAdvice {
    Map<String, String> mavenExtensions = Map.of(".md5", "download.checksum.md5", ".sha1", "download.checksum.sha-1", ".sha256", "download.checksum.sha-256", ".sha512", "download.checksum.sha-512");
    private File artifactFile;

    public MavenChecksumAdvice(File artifactFile) {
        this.artifactFile = artifactFile;
    }

    public Map<String, String> getInstallableUnitProperties(MetadataFactory.InstallableUnitDescription iu) {
        return Collections.emptyMap();
    }

    public Map<String, String> getArtifactProperties(IInstallableUnit iu, IArtifactDescriptor descriptor) {
        if (this.artifactFile != null && descriptor instanceof ArtifactDescriptor) {
            ArtifactDescriptor artifactDescriptor = (ArtifactDescriptor)descriptor;
            String baseName = this.artifactFile.getName();
            for (Map.Entry<String, String> entry : this.mavenExtensions.entrySet()) {
                File file = new File(this.artifactFile.getParentFile(), baseName + entry.getKey());
                if (!file.isFile()) continue;
                try {
                    String checksum = Files.readString(file.toPath(), StandardCharsets.US_ASCII).strip();
                    artifactDescriptor.setProperty(entry.getValue(), checksum);
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public boolean isApplicable(String configSpec, boolean includeDefault, String id, Version version) {
        return true;
    }
}

