/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.equinox.launching.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.sisu.equinox.embedder.EquinoxRuntimeLocator;
import org.eclipse.sisu.equinox.launching.BundleStartLevel;
import org.eclipse.sisu.equinox.launching.DefaultEquinoxInstallationDescription;
import org.eclipse.sisu.equinox.launching.EquinoxInstallation;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationDescription;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationFactory;
import org.eclipse.sisu.equinox.launching.EquinoxLauncher;
import org.eclipse.sisu.equinox.launching.internal.EquinoxLaunchConfiguration;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.OsgiBundleProject;

@Component(role=P2ApplicationLauncher.class, instantiationStrategy="per-lookup")
public class P2ApplicationLauncher {
    @Requirement
    private Logger logger;
    @Requirement
    private EquinoxInstallationFactory installationFactory;
    @Requirement
    private EquinoxLauncher launcher;
    @Requirement
    private EquinoxRuntimeLocator runtimeLocator;
    @Requirement(role=TychoProject.class, hint="eclipse-plugin")
    private OsgiBundleProject osgiBundle;
    private File workingDirectory;
    private String applicationName;
    private final List<String> vmargs = new ArrayList<String>();
    private final List<String> args = new ArrayList<String>();

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void addArguments(String ... args) {
        for (String arg : args) {
            this.args.add(arg);
        }
    }

    public void addVMArguments(String ... vmargs) {
        for (String vmarg : vmargs) {
            this.vmargs.add(vmarg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(int forkedProcessTimeoutInSeconds) {
        int n;
        File installationFolder = this.newTemporaryFolder();
        try {
            final DefaultEquinoxInstallationDescription description = new DefaultEquinoxInstallationDescription();
            this.runtimeLocator.locateRuntime(new EquinoxRuntimeLocator.EquinoxRuntimeDescription(){

                public void addPlatformProperty(String property, String value) {
                    description.addPlatformProperty(property, value);
                }

                public void addInstallation(File location) {
                    for (File file : new File(location, "plugins").listFiles()) {
                        P2ApplicationLauncher.this.addBundle(description, file);
                    }
                }

                public void addExtraSystemPackage(String systemPackages) {
                }

                public void addBundle(File location) {
                    P2ApplicationLauncher.this.addBundle(description, location);
                }

                public void addBundleStartLevel(String id, int level, boolean autostart) {
                    description.addBundleStartLevel(new BundleStartLevel(id, level, autostart));
                }
            });
            EquinoxInstallation installation = this.installationFactory.createInstallation(description, installationFolder);
            EquinoxLaunchConfiguration launchConfiguration = new EquinoxLaunchConfiguration(installation);
            launchConfiguration.setWorkingDirectory(this.workingDirectory);
            launchConfiguration.addProgramArguments("-configuration " + installation.getConfigurationLocation().getAbsolutePath());
            if (this.logger.isDebugEnabled()) {
                launchConfiguration.addProgramArguments("-debug", "-consoleLog");
                launchConfiguration.addProgramArguments("-console");
            }
            launchConfiguration.addProgramArguments("-nosplash", "-application", this.applicationName);
            launchConfiguration.addProgramArguments(true, this.args.toArray(new String[this.args.size()]));
            n = this.launcher.execute(launchConfiguration, forkedProcessTimeoutInSeconds);
        }
        catch (Throwable throwable) {
            try {
                try {
                    FileUtils.deleteDirectory((File)installationFolder);
                }
                catch (IOException e) {
                    this.logger.warn("Failed to delete temp folder " + installationFolder);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            FileUtils.deleteDirectory((File)installationFolder);
        }
        catch (IOException e) {
            this.logger.warn("Failed to delete temp folder " + installationFolder);
        }
        return n;
    }

    private void addBundle(EquinoxInstallationDescription description, File file) {
        ArtifactKey key = this.osgiBundle.readArtifactKey(file);
        if (key != null) {
            description.addBundle(key, file);
        }
    }

    private File newTemporaryFolder() throws IOException {
        File tmp = File.createTempFile("tycho-p2-runtime", ".tmp");
        tmp.delete();
        tmp.mkdir();
        return tmp;
    }
}

