/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.model;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.XMLIOSource;
import de.pdark.decentxml.XMLParser;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class IU {
    public static final String SOURCE_FILE_NAME = "p2iu.xml";
    private static final String UNIT = "unit";
    public static final String ID = "id";
    public static final String VERSION = "version";
    public static final String NAMESPACE = "namespace";
    public static final String NAME = "name";
    private static final String PROPERTIES = "properties";
    private static final String PROPERTY = "property";
    private static final String REQUIRES = "requires";
    private static final String REQUIRED = "required";
    public static final String RANGE = "range";
    private static final String ARTIFACTS = "artifacts";
    private static final String CLASSIFIER = "classifier";
    private static final String ARTIFACT = "artifact";
    private static final String PROVIDES = "provides";
    private static final String PROVIDED = "provided";
    public static final String P2_IU_NAMESPACE = "org.eclipse.equinox.p2.iu";
    private static XMLParser parser = new XMLParser();
    private final Document document;
    private final Element iuDom;

    public IU(Document document, Element element) {
        this.document = document;
        this.iuDom = element;
    }

    public String getId() {
        return this.iuDom.getAttributeValue(ID);
    }

    public String getVersion() {
        return this.iuDom.getAttributeValue(VERSION);
    }

    public void setVersion(String version) {
        this.iuDom.setAttribute(VERSION, version);
    }

    public List<Element> getProvidedCapabilites() {
        List provides = this.iuDom.getChildren(PROVIDES);
        if (provides == null || provides.isEmpty()) {
            return null;
        }
        return ((Element)provides.get(0)).getChildren(PROVIDED);
    }

    public List<Element> getSelfCapabilities() {
        ArrayList<Element> selfCapabilities = new ArrayList<Element>(1);
        List<Element> providedCapabilities = this.getProvidedCapabilites();
        if (providedCapabilities == null) {
            return selfCapabilities;
        }
        for (Element capability : providedCapabilities) {
            if (!this.getId().equals(capability.getAttributeValue(NAME)) || !P2_IU_NAMESPACE.equals(capability.getAttributeValue(NAMESPACE))) continue;
            selfCapabilities.add(capability);
        }
        return selfCapabilities;
    }

    public void addSelfCapability() {
        Element provides = this.iuDom.getChild(PROVIDES);
        if (provides == null) {
            provides = new Element(PROVIDES);
            this.iuDom.addNode((Node)provides);
        }
        Element newCapability = new Element(PROVIDED);
        newCapability.addAttribute(NAMESPACE, P2_IU_NAMESPACE);
        newCapability.addAttribute(NAME, this.getId());
        newCapability.addAttribute(VERSION, this.getVersion());
        provides.addNode((Node)newCapability);
    }

    public List<Element> getRequiredCapabilites() {
        List requires = this.iuDom.getChildren(REQUIRES);
        if (requires == null || requires.isEmpty()) {
            return null;
        }
        return ((Element)requires.get(0)).getChildren(REQUIRED);
    }

    public List<Element> getProperties() {
        List properties = this.iuDom.getChildren(PROPERTIES);
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        return ((Element)properties.get(0)).getChildren(PROPERTY);
    }

    public void addProperty(String name, String value) {
        Element properties = this.iuDom.getChild(PROPERTIES);
        if (properties == null) {
            this.iuDom.addNode((Node)new Element(PROPERTIES));
            properties = this.iuDom.getChild(PROPERTIES);
        }
        Element elt = new Element(PROPERTY);
        elt.setAttribute(NAME, name);
        elt.setAttribute("value", value);
        properties.addNode((Node)elt);
    }

    public List<Element> getArtifacts() {
        Element artifacts = this.iuDom.getChild(ARTIFACTS);
        if (artifacts == null) {
            return null;
        }
        return artifacts.getChildren(ARTIFACT);
    }

    public void addArtifact(String classifier, String id, String version) {
        Element artifacts = this.iuDom.getChild(ARTIFACTS);
        if (artifacts == null) {
            artifacts = new Element(ARTIFACTS);
            this.iuDom.addNode((Node)artifacts);
        }
        Element newArtifact = new Element(ARTIFACT);
        newArtifact.addAttribute(CLASSIFIER, classifier);
        newArtifact.addAttribute(ID, id);
        newArtifact.addAttribute(VERSION, version);
        artifacts.addNode((Node)newArtifact);
    }

    public Element getSelfArtifact() {
        List<Element> artifacts = this.getArtifacts();
        if (artifacts == null) {
            return null;
        }
        for (Element artifact : artifacts) {
            if (!this.getId().equals(artifact.getAttributeValue(ID)) || !"binary".equals(artifact.getAttributeValue(CLASSIFIER))) continue;
            return artifact;
        }
        return null;
    }

    public static IU read(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            Document iuDocument = parser.parse((XMLSource)new XMLIOSource((InputStream)is));
            Element root = iuDocument.getChild(UNIT);
            if (root == null) {
                throw new RuntimeException("No iu found.");
            }
            IU result = new IU(iuDocument, root);
            if (result.getId() == null) {
                throw new RuntimeException(String.format("The IU defined in %s is missing an id.", file.getAbsolutePath()));
            }
            if (result.getVersion() == null) {
                throw new RuntimeException(String.format("The IU defined in %s is missing a version.", file.getAbsolutePath()));
            }
            IU iU = result;
            return iU;
        }
    }

    public static IU loadIU(File location) {
        try {
            if (location.isDirectory()) {
                return IU.read(new File(location, SOURCE_FILE_NAME));
            }
            throw new RuntimeException("Could not read iu descriptor at " + location.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read iu descriptor at " + location.getAbsolutePath(), e);
        }
    }

    public static void write(IU iu, File file) throws IOException {
        IU.write(iu, file, "\t");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(IU iu, File file, String indent) throws IOException {
        Document document = iu.document;
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            String enc = document.getEncoding() != null ? document.getEncoding() : "UTF-8";
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, enc);
            XMLWriter xw = new XMLWriter((Writer)w);
            xw.setIndent(indent);
            try {
                document.toXML(xw);
            }
            finally {
                xw.flush();
            }
        }
    }
}

