/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.p2.facade.internal.ArtifactFacade;
import org.eclipse.tycho.p2.metadata.IP2Artifact;
import org.eclipse.tycho.p2.metadata.P2Generator;
import org.eclipse.tycho.plugins.p2.BaselineMode;
import org.eclipse.tycho.plugins.p2.BaselineReplace;
import org.eclipse.tycho.plugins.p2.BaselineValidator;
import org.eclipse.tycho.plugins.p2.Repository;

@Mojo(name="p2-metadata")
public class P2MetadataMojo
extends AbstractMojo {
    @Parameter(property="project")
    protected MavenProject project;
    @Parameter(property="mojoExecution", readonly=true)
    protected MojoExecution execution;
    @Parameter(defaultValue="true")
    protected boolean attachP2Metadata;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    private EquinoxServiceFactory equinox;
    @Parameter
    private List<String> supportedProjectTypes = Arrays.asList("eclipse-plugin", "eclipse-test-plugin", "eclipse-feature", "p2-installable-unit");
    @Parameter
    private List<Repository> baselineRepositories;
    @Parameter(property="tycho.baseline", defaultValue="warn")
    private BaselineMode baselineMode;
    @Parameter(property="tycho.baseline.replace", defaultValue="all")
    private BaselineReplace baselineReplace;
    @Component
    private BaselineValidator baselineValidator;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.attachP2Metadata();
    }

    private <T> T getService(Class<T> type) {
        Object service = this.equinox.getService(type);
        if (service == null) {
            throw new IllegalStateException("Could not acquire service " + type);
        }
        return (T)service;
    }

    protected void attachP2Metadata() throws MojoExecutionException {
        if (!this.attachP2Metadata || !this.supportedProjectTypes.contains(this.project.getPackaging())) {
            return;
        }
        File file = this.project.getArtifact().getFile();
        if (file == null || !file.canRead()) {
            throw new IllegalStateException();
        }
        File targetDir = new File(this.project.getBuild().getDirectory());
        ArtifactFacade projectDefaultArtifact = new ArtifactFacade(this.project.getArtifact());
        try {
            ArrayList<ArtifactFacade> artifacts = new ArrayList<ArtifactFacade>();
            artifacts.add(projectDefaultArtifact);
            for (Artifact attachedArtifact : this.project.getAttachedArtifacts()) {
                if (attachedArtifact.getFile() == null || !attachedArtifact.getFile().getName().endsWith(".jar") && (!attachedArtifact.getFile().getName().endsWith(".zip") || !this.project.getPackaging().equals("p2-installable-unit"))) continue;
                artifacts.add(new ArtifactFacade(attachedArtifact));
            }
            P2Generator p2generator = this.getService(P2Generator.class);
            Map<String, IP2Artifact> generatedMetadata = p2generator.generateMetadata(artifacts, targetDir);
            if (this.baselineMode != BaselineMode.disable) {
                generatedMetadata = this.baselineValidator.validateAndReplace(this.project, this.execution, generatedMetadata, this.baselineRepositories, this.baselineMode, this.baselineReplace);
            }
            File contentsXml = new File(targetDir, "p2content.xml");
            File artifactsXml = new File(targetDir, "p2artifacts.xml");
            p2generator.persistMetadata(generatedMetadata, contentsXml, artifactsXml);
            this.projectHelper.attachArtifact(this.project, "xml", "p2metadata", contentsXml);
            this.projectHelper.attachArtifact(this.project, "xml", "p2artifacts", artifactsXml);
            ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
            LinkedHashSet installableUnits = new LinkedHashSet();
            for (Map.Entry<String, IP2Artifact> entry : generatedMetadata.entrySet()) {
                String classifier = entry.getKey();
                IP2Artifact p2artifact = entry.getValue();
                installableUnits.addAll(p2artifact.getInstallableUnits());
                if (classifier == null || P2MetadataMojo.hasAttachedArtifact(this.project, classifier)) continue;
                this.projectHelper.attachArtifact(this.project, P2MetadataMojo.getExtension(p2artifact.getLocation()), classifier, p2artifact.getLocation());
            }
            reactorProject.setDependencyMetadata(true, installableUnits);
            reactorProject.setDependencyMetadata(false, Collections.emptySet());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not generate P2 metadata", (Exception)e);
        }
        File localArtifactsFile = new File(this.project.getBuild().getDirectory(), "local-artifacts.properties");
        P2MetadataMojo.writeArtifactLocations(localArtifactsFile, P2MetadataMojo.getAllProjectArtifacts(this.project));
    }

    private static boolean hasAttachedArtifact(MavenProject project, String classifier) {
        for (Artifact artifact : project.getAttachedArtifacts()) {
            if (!classifier.equals(artifact.getClassifier())) continue;
            return true;
        }
        return false;
    }

    private static String getExtension(File file) {
        String fileName = file.getName();
        int separator = fileName.lastIndexOf(46);
        if (separator < 0) {
            throw new IllegalArgumentException("No file extension in \"" + fileName + "\"");
        }
        return fileName.substring(separator + 1);
    }

    private static Map<String, File> getAllProjectArtifacts(MavenProject project) {
        HashMap<String, File> artifacts = new HashMap<String, File>();
        Artifact mainArtifact = project.getArtifact();
        if (mainArtifact != null) {
            artifacts.put(null, mainArtifact.getFile());
        }
        for (Artifact attachedArtifact : project.getAttachedArtifacts()) {
            artifacts.put(attachedArtifact.getClassifier(), attachedArtifact.getFile());
        }
        return artifacts;
    }

    static void writeArtifactLocations(File outputFile, Map<String, File> artifactLocations) throws MojoExecutionException {
        Properties outputProperties = new Properties();
        for (Map.Entry<String, File> entry : artifactLocations.entrySet()) {
            if (entry.getKey() == null) {
                outputProperties.put("artifact.main", entry.getValue().getAbsolutePath());
                continue;
            }
            outputProperties.put("artifact.attached." + entry.getKey(), entry.getValue().getAbsolutePath());
        }
        P2MetadataMojo.writeProperties(outputProperties, outputFile);
    }

    private static void writeProperties(Properties properties, File outputFile) throws MojoExecutionException {
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            properties.store(outputStream, null);
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O exception while writing " + outputFile, (Exception)e);
        }
    }
}

