/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.repository;

import java.io.File;
import java.util.Collection;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.p2.facade.RepositoryReferenceTool;
import org.eclipse.tycho.p2.tools.DestinationRepositoryDescriptor;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2.tools.mirroring.facade.MirrorApplicationService;
import org.eclipse.tycho.plugins.p2.repository.AbstractRepositoryMojo;

public class AssembleRepositoryMojo
extends AbstractRepositoryMojo
implements LogEnabled {
    private boolean createArtifactRepository;
    private boolean includeAllDependencies;
    private boolean compress;
    private String repositoryName;
    private RepositoryReferenceTool repositoryReferenceTool;
    private EquinoxServiceFactory p2;
    private Logger logger;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File destination = this.getAssemblyRepositoryLocation();
            destination.mkdirs();
            Collection rootIUs = (Collection)this.getProject().getContextValue(TychoConstants.CTX_PUBLISHED_ROOT_IUS);
            if (rootIUs == null || rootIUs.size() == 0) {
                throw new MojoFailureException("No content specified for p2 repository");
            }
            RepositoryReferences sources = this.getVisibleRepositories();
            TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration((MavenProject)this.getProject());
            MirrorApplicationService mirrorApp = (MirrorApplicationService)this.p2.getService(MirrorApplicationService.class);
            DestinationRepositoryDescriptor destinationRepoDescriptor = new DestinationRepositoryDescriptor(destination, this.repositoryName, this.compress, !this.createArtifactRepository, true);
            mirrorApp.mirrorReactor(sources, destinationRepoDescriptor, rootIUs, this.getBuildContext(), this.includeAllDependencies, configuration.isIncludePackedArtifacts());
        }
        catch (FacadeException e) {
            throw new MojoExecutionException("Could not assemble p2 repository", (Exception)((Object)e));
        }
    }

    protected RepositoryReferences getVisibleRepositories() throws MojoExecutionException, MojoFailureException {
        int flags = RepositoryReferenceTool.REPOSITORIES_INCLUDE_CURRENT_MODULE;
        return this.repositoryReferenceTool.getVisibleRepositories(this.getProject(), this.getSession(), flags);
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

